/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.util.functions.CopyTokenFunction;

class EmbalmEffect
extends OneShotEffect {
    public EmbalmEffect() {
        super(Outcome.PutCreatureInPlay);
    }

    protected EmbalmEffect(EmbalmEffect effect) {
        super(effect);
    }

    @Override
    public EmbalmEffect copy() {
        return new EmbalmEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Card card = game.getCard(source.getSourceId());
        if (card == null) {
            return false;
        }
        Player controller = game.getPlayer(card.getOwnerId());
        if (controller == null) {
            return false;
        }
        Token token = CopyTokenFunction.createTokenCopy(card, game);
        token.setColor(ObjectColor.WHITE);
        token.addSubType(SubType.ZOMBIE);
        token.clearManaCost();
        game.fireEvent(GameEvent.getEvent(GameEvent.EventType.EMBALMED_CREATURE, token.getId(), source, controller.getId()));
        token.putOntoBattlefield(1, game, source, controller.getId(), false, false, null);
        return true;
    }
}

