/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.ActivatedAbilityImpl;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.ExileSourceFromGraveCost;
import mage.abilities.keyword.EncoreEffect;
import mage.constants.TimingRule;
import mage.constants.Zone;

public class EncoreAbility
extends ActivatedAbilityImpl {
    private final String rule;

    public EncoreAbility(Cost cost) {
        super(Zone.GRAVEYARD, new EncoreEffect(), cost);
        this.addCost(new ExileSourceFromGraveCost());
        this.timing = TimingRule.SORCERY;
        this.rule = this.setRule(cost);
    }

    protected EncoreAbility(EncoreAbility ability) {
        super(ability);
        this.rule = ability.rule;
    }

    @Override
    public EncoreAbility copy() {
        return new EncoreAbility(this);
    }

    @Override
    public String getRule() {
        return this.rule;
    }

    private String setRule(Cost cost) {
        return "Encore " + cost.getText() + " <i>(" + cost.getText() + ", Exile this card from your graveyard: For each opponent, create a token copy that attacks that opponent this turn if able. They gain haste. Sacrifice them at the beginning of the next end step. Activate only as a sorcery)</i>";
    }
}

