/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.StaticAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.Costs;
import mage.abilities.costs.OptionalAdditionalCost;
import mage.abilities.costs.OptionalAdditionalCostImpl;
import mage.abilities.costs.OptionalAdditionalModeSourceCosts;
import mage.abilities.costs.VariableCostType;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

public class EntwineAbility
extends StaticAbility
implements OptionalAdditionalModeSourceCosts {
    private static final String keywordText = "Entwine";
    protected static final String reminderText = "You may {cost} in addition to any other costs to use all modes.";
    protected static final String ENTWINE_ACTIVATION_VALUE_KEY = "entwineActivation";
    protected OptionalAdditionalCost entwineCost;

    public EntwineAbility(String manaString) {
        super(Zone.STACK, null);
        this.addEntwineCostAndSetup(new OptionalAdditionalCostImpl(keywordText, reminderText, new ManaCostsImpl(manaString)));
    }

    public EntwineAbility(Cost cost) {
        this(cost, reminderText);
    }

    public EntwineAbility(Cost cost, String reminderText) {
        super(Zone.STACK, null);
        this.addEntwineCostAndSetup(new OptionalAdditionalCostImpl(keywordText, "&mdash;", reminderText, cost));
        this.setRuleAtTheTop(true);
    }

    private void addEntwineCostAndSetup(OptionalAdditionalCost newCost) {
        this.entwineCost = newCost;
        this.entwineCost.setCostType(VariableCostType.ADDITIONAL);
    }

    protected EntwineAbility(EntwineAbility ability) {
        super(ability);
        if (ability.entwineCost != null) {
            this.entwineCost = ability.entwineCost.copy();
        }
    }

    @Override
    public EntwineAbility copy() {
        return new EntwineAbility(this);
    }

    @Override
    public void addOptionalAdditionalCosts(Ability ability, Game game) {
        if (!(ability instanceof SpellAbility)) {
            return;
        }
        Player player = game.getPlayer(ability.getControllerId());
        if (player == null) {
            return;
        }
        this.resetEntwine(game, ability);
        if (this.entwineCost == null) {
            return;
        }
        if (this.entwineCost.canPay(ability, this, ability.getControllerId(), game) && player.chooseUse(Outcome.Benefit, "Pay " + this.entwineCost.getText(false) + " ?", ability, game)) {
            for (Cost cost : (Costs)((Object)this.entwineCost)) {
                if (cost instanceof ManaCostsImpl) {
                    ability.addManaCostsToPay((ManaCostsImpl)cost.copy());
                    continue;
                }
                ability.addCost(cost.copy());
            }
            ability.setCostsTag(ENTWINE_ACTIVATION_VALUE_KEY, null);
        }
    }

    @Override
    public String getRule() {
        StringBuilder sb = new StringBuilder();
        if (this.entwineCost != null) {
            sb.append(this.entwineCost.getText(false));
            sb.append(' ').append(this.entwineCost.getReminderText());
        }
        return sb.toString();
    }

    @Override
    public String getCastMessageSuffix() {
        if (this.entwineCost != null) {
            return this.entwineCost.getCastSuffixMessage(0);
        }
        return "";
    }

    @Override
    public void changeModes(Ability ability, Game game) {
        if (!this.costWasActivated(ability, game)) {
            return;
        }
        int maxModes = ability.getModes().size();
        ability.getModes().setMinModes(maxModes);
        ability.getModes().setMaxModes(maxModes);
    }

    private void resetEntwine(Game game, Ability source) {
        if (this.entwineCost != null) {
            this.entwineCost.reset();
        }
    }

    public boolean costWasActivated(Ability ability, Game game) {
        return CardUtil.checkSourceCostsTagExists(game, ability, ENTWINE_ACTIVATION_VALUE_KEY);
    }
}

