/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class EvolveEffect
extends OneShotEffect {
    public EvolveEffect() {
        super(Outcome.BoostCreature);
    }

    protected EvolveEffect(EvolveEffect effect) {
        super(effect);
    }

    @Override
    public EvolveEffect copy() {
        return new EvolveEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null) {
            return false;
        }
        permanent.addCounters(CounterType.P1P1.createInstance(), source, game);
        game.fireEvent(GameEvent.getEvent(GameEvent.EventType.EVOLVED_CREATURE, permanent.getId(), source, source.getControllerId()));
        return false;
    }
}

