/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.MageSingleton;
import mage.abilities.effects.RestrictionEffect;
import mage.abilities.keyword.FearAbility;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

class FearEffect
extends RestrictionEffect
implements MageSingleton {
    public FearEffect() {
        super(Duration.EndOfGame);
    }

    protected FearEffect(FearEffect effect) {
        super(effect);
    }

    @Override
    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.getAbilities().containsKey(FearAbility.getInstance().getId());
    }

    @Override
    public boolean canBeBlocked(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        return blocker.isArtifact(game) || blocker.getColor(game).isBlack();
    }

    @Override
    public FearEffect copy() {
        return new FearEffect(this);
    }
}

