/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.AbilityImpl;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.ForetellAbility;
import mage.cards.Card;
import mage.cards.CardWithSpellOption;
import mage.cards.ModalDoubleFacedCard;
import mage.cards.ModalDoubleFacedCardHalf;
import mage.cards.SplitCard;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.common.FilterNonlandCard;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class ForetellAddAbilityEffect
extends ContinuousEffectImpl {
    private static final FilterNonlandCard filter = new FilterNonlandCard();

    ForetellAddAbilityEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "Each nonland card in your hand without foretell has foretell. Its foretell cost is equal to its mana cost reduced by {2}";
    }

    private ForetellAddAbilityEffect(ForetellAddAbilityEffect effect) {
        super(effect);
    }

    @Override
    public ForetellAddAbilityEffect copy() {
        return new ForetellAddAbilityEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        for (Card card : controller.getHand().getCards(filter, game)) {
            AbilityImpl foretellAbility = null;
            if (card instanceof SplitCard) {
                String leftHalfCost = CardUtil.reduceCost(((SplitCard)card).getLeftHalfCard().getManaCost(), 2).getText();
                String rightHalfCost = CardUtil.reduceCost(((SplitCard)card).getRightHalfCard().getManaCost(), 2).getText();
                foretellAbility = new ForetellAbility(card, leftHalfCost, rightHalfCost);
            } else if (card instanceof ModalDoubleFacedCard) {
                ModalDoubleFacedCardHalf leftHalfCard = ((ModalDoubleFacedCard)card).getLeftHalfCard();
                if (!leftHalfCard.isLand(game)) {
                    String leftHalfCost = CardUtil.reduceCost(leftHalfCard.getManaCost(), 2).getText();
                    ModalDoubleFacedCardHalf rightHalfCard = ((ModalDoubleFacedCard)card).getRightHalfCard();
                    if (rightHalfCard.isLand(game)) {
                        foretellAbility = new ForetellAbility(card, leftHalfCost);
                    } else {
                        String rightHalfCost = CardUtil.reduceCost(rightHalfCard.getManaCost(), 2).getText();
                        foretellAbility = new ForetellAbility(card, leftHalfCost, rightHalfCost);
                    }
                }
            } else if (card instanceof CardWithSpellOption) {
                String creatureCost = CardUtil.reduceCost(card.getMainCard().getManaCost(), 2).getText();
                String spellCost = CardUtil.reduceCost(((CardWithSpellOption)card).getSpellCard().getManaCost(), 2).getText();
                foretellAbility = new ForetellAbility(card, creatureCost, spellCost);
            } else {
                String costText = CardUtil.reduceCost(card.getManaCost(), 2).getText();
                foretellAbility = new ForetellAbility(card, costText);
            }
            if (foretellAbility == null) continue;
            foretellAbility.setSourceId(card.getId());
            foretellAbility.setControllerId(card.getOwnerId());
            game.getState().addOtherAbility(card, foretellAbility);
        }
        return true;
    }

    static {
        filter.add(Predicates.not(new AbilityPredicate(ForetellAbility.class)));
    }
}

