/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.UUID;
import mage.abilities.ActivatedAbility;
import mage.abilities.SpellAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.Costs;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.cards.Card;
import mage.cards.CardWithSpellOption;
import mage.cards.ModalDoubleFacedCard;
import mage.cards.SplitCard;
import mage.constants.SpellAbilityCastMode;
import mage.constants.SpellAbilityType;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;

class ForetellCostAbility
extends SpellAbility {
    private String abilityName;
    private SpellAbility spellAbilityToResolve;

    ForetellCostAbility(String foretellCost) {
        super(null, "Testing", Zone.EXILED, SpellAbilityType.BASE_ALTERNATE, SpellAbilityCastMode.NORMAL);
        if (foretellCost != null && foretellCost.isEmpty()) {
            foretellCost = "{0}";
        }
        this.setAdditionalCostsRuleVisible(false);
        this.name = "Foretell " + foretellCost;
        this.addCost(new ManaCostsImpl(foretellCost));
    }

    private ForetellCostAbility(ForetellCostAbility ability) {
        super(ability);
        this.spellAbilityType = ability.spellAbilityType;
        this.abilityName = ability.abilityName;
        this.spellAbilityToResolve = ability.spellAbilityToResolve;
    }

    @Override
    public ActivatedAbility.ActivationStatus canActivate(UUID playerId, Game game) {
        Card card;
        if (super.canActivate(playerId, game).canActivate() && (card = game.getCard(this.getSourceId())) != null) {
            UUID mainCardId = card.getMainCard().getId();
            if (game.getState().getZone(mainCardId) != Zone.EXILED) {
                return ActivatedAbility.ActivationStatus.getFalse();
            }
            Integer foretoldTurn = (Integer)game.getState().getValue(mainCardId.toString() + "Foretell Turn Number");
            UUID exileId = (UUID)game.getState().getValue(mainCardId.toString() + "foretellAbility");
            if (foretoldTurn == null || exileId == null) {
                return ActivatedAbility.ActivationStatus.getFalse();
            }
            if (foretoldTurn.intValue() == game.getTurnNum()) {
                return ActivatedAbility.ActivationStatus.getFalse();
            }
            ExileZone exileZone = game.getState().getExile().getExileZone(exileId);
            if (exileZone != null && exileZone.isEmpty()) {
                return ActivatedAbility.ActivationStatus.getFalse();
            }
            if (card instanceof SplitCard) {
                if (((SplitCard)card).getLeftHalfCard().getName().equals(this.abilityName)) {
                    return ((SplitCard)card).getLeftHalfCard().getSpellAbility().canActivate(playerId, game);
                }
                if (((SplitCard)card).getRightHalfCard().getName().equals(this.abilityName)) {
                    return ((SplitCard)card).getRightHalfCard().getSpellAbility().canActivate(playerId, game);
                }
            } else if (card instanceof ModalDoubleFacedCard) {
                if (((ModalDoubleFacedCard)card).getLeftHalfCard().getName().equals(this.abilityName)) {
                    return ((ModalDoubleFacedCard)card).getLeftHalfCard().getSpellAbility().canActivate(playerId, game);
                }
                if (((ModalDoubleFacedCard)card).getRightHalfCard().getName().equals(this.abilityName)) {
                    return ((ModalDoubleFacedCard)card).getRightHalfCard().getSpellAbility().canActivate(playerId, game);
                }
            } else if (card instanceof CardWithSpellOption) {
                if (card.getMainCard().getName().equals(this.abilityName)) {
                    return card.getMainCard().getSpellAbility().canActivate(playerId, game);
                }
                if (((CardWithSpellOption)card).getSpellCard().getName().equals(this.abilityName)) {
                    return ((CardWithSpellOption)card).getSpellCard().getSpellAbility().canActivate(playerId, game);
                }
            }
            return card.getSpellAbility().canActivate(playerId, game);
        }
        return ActivatedAbility.ActivationStatus.getFalse();
    }

    @Override
    public SpellAbility getSpellAbilityToResolve(Game game) {
        Card card = game.getCard(this.getSourceId());
        if (card != null && this.spellAbilityToResolve == null) {
            SpellAbility spellAbilityCopy = null;
            if (card instanceof SplitCard) {
                if (((SplitCard)card).getLeftHalfCard().getName().equals(this.abilityName)) {
                    spellAbilityCopy = ((SplitCard)card).getLeftHalfCard().getSpellAbility().copy();
                } else if (((SplitCard)card).getRightHalfCard().getName().equals(this.abilityName)) {
                    spellAbilityCopy = ((SplitCard)card).getRightHalfCard().getSpellAbility().copy();
                }
            } else if (card instanceof ModalDoubleFacedCard) {
                if (((ModalDoubleFacedCard)card).getLeftHalfCard().getName().equals(this.abilityName)) {
                    spellAbilityCopy = ((ModalDoubleFacedCard)card).getLeftHalfCard().getSpellAbility().copy();
                } else if (((ModalDoubleFacedCard)card).getRightHalfCard().getName().equals(this.abilityName)) {
                    spellAbilityCopy = ((ModalDoubleFacedCard)card).getRightHalfCard().getSpellAbility().copy();
                }
            } else if (card instanceof CardWithSpellOption) {
                if (card.getMainCard().getName().equals(this.abilityName)) {
                    spellAbilityCopy = card.getMainCard().getSpellAbility().copy();
                } else if (((CardWithSpellOption)card).getSpellCard().getName().equals(this.abilityName)) {
                    spellAbilityCopy = ((CardWithSpellOption)card).getSpellCard().getSpellAbility().copy();
                }
            } else {
                spellAbilityCopy = card.getSpellAbility().copy();
            }
            if (spellAbilityCopy == null) {
                return null;
            }
            spellAbilityCopy.setId(this.getId());
            spellAbilityCopy.clearManaCosts();
            spellAbilityCopy.clearManaCostsToPay();
            spellAbilityCopy.addCost(this.getCosts().copy());
            spellAbilityCopy.addCost(this.getManaCosts().copy());
            spellAbilityCopy.setSpellAbilityCastMode(this.getSpellAbilityCastMode());
            this.spellAbilityToResolve = spellAbilityCopy;
        }
        return this.spellAbilityToResolve;
    }

    @Override
    public Costs<Cost> getCosts() {
        if (this.spellAbilityToResolve == null) {
            return super.getCosts();
        }
        return this.spellAbilityToResolve.getCosts();
    }

    @Override
    public ForetellCostAbility copy() {
        return new ForetellCostAbility(this);
    }

    @Override
    public String getRule(boolean all) {
        StringBuilder sbRule = new StringBuilder("Foretell");
        if (!this.getCosts().isEmpty()) {
            sbRule.append("&mdash;");
        } else {
            sbRule.append(' ');
        }
        if (!this.getManaCosts().isEmpty()) {
            sbRule.append(this.getManaCosts().getText());
        }
        if (!this.getCosts().isEmpty()) {
            if (!this.getManaCosts().isEmpty()) {
                sbRule.append(", ");
            }
            sbRule.append(this.getCosts().getText());
            sbRule.append('.');
        }
        if (this.abilityName != null) {
            sbRule.append(' ');
            sbRule.append(this.abilityName);
        }
        sbRule.append(" <i>(You may cast this card from exile for its foretell cost.)</i>");
        return sbRule.toString();
    }

    void setAbilityName(String abilityName) {
        this.abilityName = abilityName;
    }
}

