/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.HasteAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;

class GainHasteEffect
extends ContinuousEffectImpl {
    private UUID suspendController;

    GainHasteEffect() {
        super(Duration.Custom, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "If you cast a creature spell this way, it gains haste until you lose control of the spell or the permanent it becomes.";
    }

    private GainHasteEffect(GainHasteEffect effect) {
        super(effect);
        this.suspendController = effect.suspendController;
    }

    @Override
    public GainHasteEffect copy() {
        return new GainHasteEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent;
        if (this.suspendController == null) {
            this.suspendController = source.getControllerId();
        }
        if ((permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source))) != null) {
            if (this.suspendController.equals(source.getControllerId())) {
                permanent.addAbility(HasteAbility.getInstance(), source.getSourceId(), game);
            } else {
                this.discard();
            }
            return true;
        }
        if (game.getState().getZoneChangeCounter(((FixedTarget)this.getTargetPointer()).getTarget()) >= ((FixedTarget)this.getTargetPointer()).getZoneChangeCounter()) {
            this.discard();
        }
        return false;
    }
}

