/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class GraftDistributeCounterEffect
extends OneShotEffect {
    public GraftDistributeCounterEffect() {
        super(Outcome.Detriment);
        this.staticText = "you may move a +1/+1 counter from this permanent onto it";
    }

    protected GraftDistributeCounterEffect(GraftDistributeCounterEffect effect) {
        super(effect);
    }

    @Override
    public GraftDistributeCounterEffect copy() {
        return new GraftDistributeCounterEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent targetCreature;
        int numberOfCounters;
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (sourcePermanent != null && (numberOfCounters = sourcePermanent.getCounters(game).getCount(CounterType.P1P1)) > 0 && (targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source))) != null) {
            sourcePermanent.removeCounters(CounterType.P1P1.getName(), 1, source, game);
            targetCreature.addCounters(CounterType.P1P1.createInstance(1), source.getControllerId(), source, game);
            if (!game.isSimulation()) {
                game.informPlayers("Moved one +1/+1 counter from " + sourcePermanent.getLogName() + " to " + targetCreature.getLogName());
            }
            return true;
        }
        return false;
    }
}

