/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.MageObjectReference;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.hint.ValueHint;
import mage.abilities.keyword.GravestormEffect;
import mage.abilities.keyword.PermanentsDestroyedThisTurnValue;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.watchers.common.GravestormWatcher;

public class GravestormAbility
extends TriggeredAbilityImpl {
    public GravestormAbility() {
        super(Zone.STACK, new GravestormEffect());
        this.addWatcher(new GravestormWatcher());
        this.addHint(new ValueHint("Permanents put into graveyards from the battlefield this turn", PermanentsDestroyedThisTurnValue.instance));
    }

    private GravestormAbility(GravestormAbility ability) {
        super(ability);
    }

    @Override
    public GravestormAbility copy() {
        return new GravestormAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        StackObject spell;
        if (event.getSourceId().equals(this.getSourceId()) && (spell = game.getStack().getStackObject(this.getSourceId())) instanceof Spell) {
            for (Effect effect : this.getEffects()) {
                effect.setValue("GravestormSpell", spell);
                effect.setValue("GravestormSpellRef", new MageObjectReference(spell.getId(), game));
            }
            return true;
        }
        return false;
    }

    @Override
    public String getRule() {
        return "Gravestorm <i>(When you cast this spell, copy it for each permanent put into a graveyard this turn. You may choose new targets for the copies.)</i>";
    }
}

