/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.keyword.HauntExileAbility;
import mage.cards.Card;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.target.targetpointer.FixedTarget;

public class HauntAbility
extends TriggeredAbilityImpl {
    private boolean usedFromExile = false;

    public HauntAbility(Card card, Effect effect) {
        super(Zone.ALL, effect, false);
        boolean creatureHaunt = card.isCreature();
        this.addSubAbility(new HauntExileAbility(creatureHaunt));
        this.setTriggerPhrase(creatureHaunt ? "When {this} enters or the creature it haunts dies, " : "When the creature {this} haunts dies, ");
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private HauntAbility(HauntAbility ability) {
        super(ability);
        this.usedFromExile = ability.usedFromExile;
    }

    @Override
    public HauntAbility copy() {
        return new HauntAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD || event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        switch (event.getType()) {
            case ENTERS_THE_BATTLEFIELD: {
                return game.getState().getZone(this.getSourceId()) == Zone.BATTLEFIELD && event.getTargetId().equals(this.getSourceId());
            }
            case ZONE_CHANGE: {
                if (this.usedFromExile || game.getState().getZone(this.getSourceId()) != Zone.EXILED) {
                    return false;
                }
                ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
                if (!zEvent.isDiesEvent()) {
                    return false;
                }
                Card card = game.getCard(this.getSourceId());
                if (card == null) {
                    return false;
                }
                String key = "Haunting_" + this.getSourceId().toString() + (card.getZoneChangeCounter(game) + game.getPermanentOrLKIBattlefield(event.getTargetId()).getZoneChangeCounter(game));
                Object object = game.getState().getValue(key);
                if (!(object instanceof FixedTarget)) {
                    return false;
                }
                FixedTarget target = (FixedTarget)object;
                if (target.getTarget() == null || !target.getTarget().equals(event.getTargetId())) break;
                this.usedFromExile = true;
                return true;
            }
        }
        return false;
    }
}

