/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class HideawayWatcher
extends Watcher {
    private final Map<MageObjectReference, Set<UUID>> morMap = new HashMap<MageObjectReference, Set<UUID>>();

    HideawayWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        UUID playerId;
        Permanent permanent;
        switch (event.getType()) {
            case GAINED_CONTROL: {
                permanent = game.getPermanent(event.getTargetId());
                playerId = event.getPlayerId();
                break;
            }
            case ENTERS_THE_BATTLEFIELD: {
                permanent = ((EntersTheBattlefieldEvent)event).getTarget();
                playerId = permanent.getControllerId();
                break;
            }
            case BEGINNING_PHASE_PRE: {
                if (game.getTurnNum() == 1) {
                    this.morMap.clear();
                }
            }
            default: {
                return;
            }
        }
        this.morMap.computeIfAbsent(new MageObjectReference(permanent, game), x -> new HashSet()).add(playerId);
    }

    static boolean check(UUID playerId, Ability source, Game game) {
        return game.getState().getWatcher(HideawayWatcher.class).morMap.getOrDefault(new MageObjectReference(source), Collections.emptySet()).contains(playerId);
    }
}

