/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.common.EntersBattlefieldAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.SourceHasCounterCondition;
import mage.abilities.costs.AlternativeSourceCostsImpl;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.decorator.ConditionalOneShotEffect;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AddContinuousEffectToGame;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.abilities.effects.common.counter.RemoveCounterSourceEffect;
import mage.abilities.keyword.ImpendingAbilityRemoveEffect;
import mage.abilities.keyword.ImpendingAbilityTypeEffect;
import mage.abilities.keyword.ImpendingCondition;
import mage.abilities.triggers.BeginningOfEndStepTriggeredAbility;
import mage.constants.ComparisonType;
import mage.constants.TargetController;
import mage.counters.CounterType;
import mage.util.CardUtil;

public class ImpendingAbility
extends AlternativeSourceCostsImpl {
    private static final String IMPENDING_KEYWORD = "Impending";
    private static final String IMPENDING_REMINDER = "If you cast this spell for its impending cost, it enters with %s time counters and isn't a creature until the last is removed. At the beginning of your end step, remove a time counter from it.";
    private static final Condition counterCondition = new SourceHasCounterCondition(CounterType.TIME, ComparisonType.EQUAL_TO, 0);

    public ImpendingAbility(int amount, String manaString) {
        super("Impending " + amount, String.format(IMPENDING_REMINDER, CardUtil.numberToText(amount)), new ManaCostsImpl(manaString), IMPENDING_KEYWORD);
        this.setRuleAtTheTop(true);
        this.addSubAbility(new EntersBattlefieldAbility((Effect)new ConditionalOneShotEffect(new AddCountersSourceEffect(CounterType.TIME.createInstance(amount)), ImpendingCondition.instance, ""), "").setRuleVisible(false));
        this.addSubAbility(new SimpleStaticAbility(new ImpendingAbilityTypeEffect()).setRuleVisible(false));
        BeginningOfEndStepTriggeredAbility ability = new BeginningOfEndStepTriggeredAbility(TargetController.YOU, new RemoveCounterSourceEffect(CounterType.TIME.createInstance()), false, ImpendingCondition.instance);
        ability.addEffect(new ConditionalOneShotEffect(new AddContinuousEffectToGame(new ContinuousEffect[]{new ImpendingAbilityRemoveEffect()}), counterCondition, "Then if it has no time counters on it, it loses impending"));
        this.addSubAbility(ability.setRuleVisible(false));
    }

    private ImpendingAbility(ImpendingAbility ability) {
        super(ability);
    }

    @Override
    public ImpendingAbility copy() {
        return new ImpendingAbility(this);
    }

    public static String getActivationKey() {
        return ImpendingAbility.getActivationKey(IMPENDING_KEYWORD);
    }
}

