/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.ImpendingCondition;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ImpendingAbilityTypeEffect
extends ContinuousEffectImpl {
    ImpendingAbilityTypeEffect() {
        super(Duration.WhileOnBattlefield, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Detriment);
        this.staticText = "As long as this permanent has a time counter on it, if it was cast for its impending cost, it's not a creature.";
    }

    private ImpendingAbilityTypeEffect(ImpendingAbilityTypeEffect effect) {
        super(effect);
    }

    @Override
    public ImpendingAbilityTypeEffect copy() {
        return new ImpendingAbilityTypeEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        if (!ImpendingCondition.instance.apply(game, source)) {
            return false;
        }
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent.getCounters(game).getCount(CounterType.TIME) < 1) {
            return false;
        }
        permanent.removeCardType(game, CardType.CREATURE);
        permanent.removeAllCreatureTypes(game);
        return true;
    }
}

