/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.players.Player;

class JumpStartReplacementEffect
extends ReplacementEffectImpl {
    public JumpStartReplacementEffect() {
        super(Duration.OneUse, Outcome.Exile);
        this.staticText = "(If this spell was cast with jump-start, exile it instead of putting it anywhere else any time it would leave the stack)";
    }

    protected JumpStartReplacementEffect(JumpStartReplacementEffect effect) {
        super(effect);
    }

    @Override
    public JumpStartReplacementEffect copy() {
        return new JumpStartReplacementEffect(this);
    }

    @Override
    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && (card = game.getCard(event.getTargetId())) != null) {
            this.discard();
            return controller.moveCards(card, Zone.EXILED, source, game, false, false, false, event.getAppliedEffects());
        }
        return false;
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event.getTargetId().equals(source.getSourceId()) && ((ZoneChangeEvent)event).getFromZone() == Zone.STACK && ((ZoneChangeEvent)event).getToZone() != Zone.EXILED) {
            return game.getState().getZoneChangeCounter(source.getSourceId()) == source.getStackMomentSourceZCC() + 1;
        }
        return false;
    }
}

