/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.StaticAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.Costs;
import mage.abilities.costs.OptionalAdditionalCost;
import mage.abilities.costs.OptionalAdditionalCostImpl;
import mage.abilities.costs.OptionalAdditionalSourceCosts;
import mage.abilities.costs.VariableCostType;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.util.CardUtil;

public class KickerAbility
extends StaticAbility
implements OptionalAdditionalSourceCosts {
    protected static final String KICKER_KEYWORD = "Kicker";
    protected static final String KICKER_REMINDER_MANA = "You may pay an additional {cost} as you cast this spell.";
    protected static final String KICKER_REMINDER_COST = "You may {cost} in addition to any other costs as you cast this spell.";
    protected String keywordText;
    protected String reminderText;
    protected List<OptionalAdditionalCost> kickerCosts = new LinkedList<OptionalAdditionalCost>();

    public KickerAbility(String manaString) {
        this(KICKER_KEYWORD, KICKER_REMINDER_MANA);
        this.addKickerCost(manaString);
    }

    public KickerAbility(Cost cost) {
        this(KICKER_KEYWORD, KICKER_REMINDER_COST);
        this.addKickerCost(cost);
    }

    public KickerAbility(String keywordText, String reminderText) {
        super(Zone.STACK, null);
        this.name = keywordText;
        this.keywordText = keywordText;
        this.reminderText = reminderText;
        this.setRuleAtTheTop(true);
    }

    protected KickerAbility(KickerAbility ability) {
        super(ability);
        for (OptionalAdditionalCost cost : ability.kickerCosts) {
            this.kickerCosts.add(cost.copy());
        }
        this.keywordText = ability.keywordText;
        this.reminderText = ability.reminderText;
    }

    @Override
    public KickerAbility copy() {
        return new KickerAbility(this);
    }

    public final OptionalAdditionalCost addKickerCost(String manaString) {
        OptionalAdditionalCostImpl newCost = new OptionalAdditionalCostImpl(this.keywordText, this.reminderText, new ManaCostsImpl(manaString));
        this.addKickerCostAndSetup(newCost);
        return newCost;
    }

    public final OptionalAdditionalCost addKickerCost(Cost cost) {
        OptionalAdditionalCostImpl newCost = new OptionalAdditionalCostImpl(this.keywordText, "&mdash;", this.reminderText, cost);
        this.addKickerCostAndSetup(newCost);
        return newCost;
    }

    private void addKickerCostAndSetup(OptionalAdditionalCost newCost) {
        this.kickerCosts.add(newCost);
        this.kickerCosts.forEach(cost -> cost.setCostType(VariableCostType.ADDITIONAL));
    }

    private void resetKicker() {
        for (OptionalAdditionalCost cost : this.kickerCosts) {
            cost.reset();
        }
    }

    private static String getActivationKey(String needKickerCost) {
        return "kickerActivation" + needKickerCost;
    }

    public static int getKickedCounterStrict(Game game, Ability source, String needKickerCost) {
        Map<String, Object> costsTags = CardUtil.getSourceCostsTagsMap(game, source);
        if (costsTags == null) {
            return 0;
        }
        String finalActivationKey = KickerAbility.getActivationKey(needKickerCost);
        Stream<Map.Entry> tagStream = costsTags.entrySet().stream().filter(x -> ((String)x.getKey()).startsWith(finalActivationKey));
        return tagStream.mapToInt(x -> {
            Object value = x.getValue();
            if (!(value instanceof Integer)) {
                throw new IllegalStateException("Wrong code usage: Kicker tag " + (String)x.getKey() + " needs Integer but has " + (value == null ? "null" : value.getClass().getName()));
            }
            return (Integer)value;
        }).sum();
    }

    public static int getKickedCounter(Game game, Ability source) {
        return KickerAbility.getKickedCounterStrict(game, source, "");
    }

    public boolean isKicked(Game game, Ability source) {
        return this.isKicked(game, source, "");
    }

    public boolean isKicked(Game game, Ability source, String needKickerCost) {
        return KickerAbility.getKickedCounterStrict(game, source, needKickerCost) > 0;
    }

    public List<OptionalAdditionalCost> getKickerCosts() {
        return this.kickerCosts;
    }

    private void activateKicker(OptionalAdditionalCost kickerCost, Ability source, Game game) {
        game.fireEvent(GameEvent.getEvent(GameEvent.EventType.KICKED, source.getSourceId(), source, source.getControllerId()));
        String activationKey = KickerAbility.getActivationKey(kickerCost.getText(true));
        Integer next = CardUtil.getSourceCostsTag(game, source, activationKey, 0) + 1;
        source.setCostsTag(activationKey, next);
    }

    @Override
    public void addOptionalAdditionalCosts(Ability ability, Game game) {
        if (!(ability instanceof SpellAbility)) {
            return;
        }
        Player player = game.getPlayer(ability.getControllerId());
        if (player == null) {
            return;
        }
        this.resetKicker();
        for (OptionalAdditionalCost kickerCost : this.kickerCosts) {
            boolean again = true;
            while (player.canRespond() && again) {
                String times = "";
                if (kickerCost.isRepeatable()) {
                    int activatedCount = KickerAbility.getKickedCounterStrict(game, ability, kickerCost.getText(true));
                    times = activatedCount + 1 + (activatedCount == 0 ? " time " : " times ");
                }
                if (kickerCost.canPay(ability, this, ability.getControllerId(), game) && player.chooseUse(Outcome.AIDontUseIt, "Pay " + times + kickerCost.getText(false) + " ?", ability, game)) {
                    this.activateKicker(kickerCost, ability, game);
                    if (kickerCost instanceof Costs) {
                        for (Object kickerCostObject : (Costs)((Object)kickerCost)) {
                            if (kickerCostObject instanceof Costs) {
                                Iterator itDetails = ((Costs)kickerCostObject).iterator();
                                while (itDetails.hasNext()) {
                                    this.addKickerCostsToAbility((Cost)itDetails.next(), ability, game);
                                }
                                continue;
                            }
                            this.addKickerCostsToAbility((Cost)kickerCostObject, ability, game);
                        }
                    } else {
                        this.addKickerCostsToAbility(kickerCost, ability, game);
                    }
                    again = kickerCost.isRepeatable();
                    continue;
                }
                again = false;
            }
        }
    }

    private void addKickerCostsToAbility(Cost cost, Ability ability, Game game) {
        if (cost instanceof ManaCostsImpl) {
            ability.addManaCostsToPay((ManaCostsImpl)cost.copy());
        } else {
            ability.addCost(cost.copy());
        }
    }

    @Override
    public String getRule() {
        StringBuilder sb = new StringBuilder();
        int numberKicker = 0;
        String remarkText = "";
        for (OptionalAdditionalCost kickerCost : this.kickerCosts) {
            if (numberKicker == 0) {
                sb.append(kickerCost.getText(false));
                remarkText = kickerCost.getReminderText();
            } else {
                sb.append(" and/or ").append(kickerCost.getText(true));
            }
            ++numberKicker;
        }
        if (numberKicker == 1) {
            sb.append(' ').append(remarkText);
        }
        return sb.toString().replace(" .", ".");
    }

    @Override
    public String getCastMessageSuffix() {
        StringBuilder sb = new StringBuilder();
        int position = 0;
        for (OptionalAdditionalCost cost : this.kickerCosts) {
            if (!cost.isActivated()) continue;
            sb.append(cost.getCastSuffixMessage(position));
            ++position;
        }
        return sb.toString();
    }
}

