/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.filter.common.FilterControlledLandPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;

class LandwalkEffect
extends RestrictionEffect {
    private final FilterControlledLandPermanent filter;

    LandwalkEffect(FilterControlledLandPermanent filter, boolean withHintText) {
        super(Duration.WhileOnBattlefield);
        this.filter = filter;
        this.staticText = this.setText(withHintText);
    }

    private LandwalkEffect(LandwalkEffect effect) {
        super(effect);
        this.filter = effect.filter.copy();
    }

    @Override
    public boolean canBeBlocked(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        if (game.getBattlefield().contains(this.filter, blocker.getControllerId(), source, game, 1) && game.getContinuousEffects().asThough(blocker.getId(), AsThoughEffectType.BLOCK_LANDWALK, null, blocker.getControllerId(), game).isEmpty()) {
            switch (this.filter.getMessage()) {
                case "plains": {
                    return !game.getContinuousEffects().asThough(blocker.getId(), AsThoughEffectType.BLOCK_PLAINSWALK, null, blocker.getControllerId(), game).isEmpty();
                }
                case "island": {
                    return !game.getContinuousEffects().asThough(blocker.getId(), AsThoughEffectType.BLOCK_ISLANDWALK, null, blocker.getControllerId(), game).isEmpty();
                }
                case "swamp": {
                    return !game.getContinuousEffects().asThough(blocker.getId(), AsThoughEffectType.BLOCK_SWAMPWALK, null, blocker.getControllerId(), game).isEmpty();
                }
                case "mountain": {
                    return !game.getContinuousEffects().asThough(blocker.getId(), AsThoughEffectType.BLOCK_MOUNTAINWALK, null, blocker.getControllerId(), game).isEmpty();
                }
                case "forest": {
                    return !game.getContinuousEffects().asThough(blocker.getId(), AsThoughEffectType.BLOCK_FORESTWALK, null, blocker.getControllerId(), game).isEmpty();
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.getId().equals(source.getSourceId());
    }

    @Override
    public LandwalkEffect copy() {
        return new LandwalkEffect(this);
    }

    private String setText(boolean withHintText) {
        if (this.filter.getMessage().startsWith("chosen type")) {
            return "landwalk of the chosen type";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.filter.getMessage()).append("walk");
        if (withHintText) {
            sb.append(" <i>(This creature can't be blocked as long as defending player controls ");
            switch (this.filter.getMessage()) {
                case "swamp": {
                    sb.append("a Swamp");
                    break;
                }
                case "plains": {
                    sb.append("a Plains");
                    break;
                }
                case "mountain": {
                    sb.append("a Mountain");
                    break;
                }
                case "forest": {
                    sb.append("a Forest");
                    break;
                }
                case "island": {
                    sb.append("an Island");
                    break;
                }
                default: {
                    sb.append("a " + this.filter.getMessage());
                }
            }
            sb.append(".)</i>");
        }
        return sb.toString();
    }
}

