/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.MageObjectReference;
import mage.cards.Card;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.DiscardedCardsEvent;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class MayhemWatcher
extends Watcher {
    private final Set<MageObjectReference> set = new HashSet<MageObjectReference>();

    MayhemWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.DISCARDED_CARDS) {
            return;
        }
        for (Card card : ((DiscardedCardsEvent)event).getDiscardedCards().getCards(game)) {
            this.set.add(new MageObjectReference(card, game));
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.set.clear();
    }

    static boolean checkCard(UUID cardId, Game game) {
        return game.getState().getWatcher(MayhemWatcher.class).set.stream().anyMatch(mor -> mor.refersTo(cardId, game));
    }
}

