/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class MeditateEffect
extends OneShotEffect {
    MeditateEffect() {
        super(Outcome.ReturnToHand);
    }

    protected MeditateEffect(MeditateEffect effect) {
        super(effect);
    }

    @Override
    public MeditateEffect copy() {
        return new MeditateEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (controller == null || permanent == null) {
            return false;
        }
        boolean ret = controller.moveCards(permanent, Zone.HAND, source, game);
        if (ret) {
            game.fireEvent(new GameEvent(GameEvent.EventType.MEDITATED, source.getSourceId(), source, controller.getId()));
        }
        return ret;
    }
}

