/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.keyword.MiracleEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.targetpointer.FixedTarget;
import mage.watchers.common.MiracleWatcher;

public class MiracleAbility
extends TriggeredAbilityImpl {
    private static final String staticRule = " <i>(You may cast this card for its miracle cost when you draw it if it's the first card you drew this turn.)</i>";
    private final String ruleText;

    public MiracleAbility(String miracleCosts) {
        super(Zone.HAND, new MiracleEffect(miracleCosts), true);
        this.addWatcher(new MiracleWatcher());
        this.ruleText = "Miracle " + miracleCosts + staticRule;
    }

    private MiracleAbility(MiracleAbility ability) {
        super(ability);
        this.ruleText = ability.ruleText;
    }

    @Override
    public MiracleAbility copy() {
        return new MiracleAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.MIRACLE_CARD_REVEALED;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getTargetId().equals(this.getSourceId())) {
            this.getEffects().setTargetPointer(new FixedTarget(game.getCard(event.getTargetId()), game));
            return true;
        }
        return false;
    }

    @Override
    public String getRule() {
        return this.ruleText;
    }
}

