/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.common.DiesSourceTriggeredAbility;
import mage.abilities.keyword.ModularDistributeCounterEffect;
import mage.abilities.keyword.ModularStaticAbility;
import mage.abilities.keyword.SunburstAbility;
import mage.cards.Card;
import mage.constants.CardType;
import mage.counters.CounterType;
import mage.filter.common.FilterArtifactPermanent;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.target.TargetPermanent;
import mage.util.CardUtil;

public class ModularAbility
extends DiesSourceTriggeredAbility {
    private static final FilterArtifactPermanent filter = new FilterArtifactPermanent("artifact creature");
    private final int amount;
    private final boolean sunburst;

    public ModularAbility(Card card, int amount) {
        this(card, amount, false);
    }

    public ModularAbility(Card card, int amount, boolean sunburst) {
        super(new ModularDistributeCounterEffect(), true);
        this.addTarget(new TargetPermanent(filter));
        this.amount = amount;
        this.sunburst = sunburst;
        if (sunburst) {
            SunburstAbility ability = new SunburstAbility(card);
            ability.setRuleVisible(false);
            this.addSubAbility(ability);
        } else {
            this.addSubAbility(new ModularStaticAbility(amount));
        }
    }

    private ModularAbility(ModularAbility ability) {
        super(ability);
        this.amount = ability.amount;
        this.sunburst = ability.sunburst;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent;
        return super.checkTrigger(event, game) && (zEvent = (ZoneChangeEvent)event).getTarget().getCounters(game).getCount(CounterType.P1P1) > 0;
    }

    @Override
    public ModularAbility copy() {
        return new ModularAbility(this);
    }

    @Override
    public String getRule() {
        if (this.sunburst) {
            return "Modular&mdash;Sunburst <i>(This enters the battlefield with a +1/+1 counter on it for each color of mana spent to cast it. When it dies, you may put its +1/+1 counters on target artifact creature.)</i>";
        }
        return "Modular " + this.amount + " <i>(This creature enters the battlefield with " + CardUtil.getOneOneCountersText(this.amount) + " on it. When it dies, you may put its +1/+1 counters on target artifact creature.)</i>";
    }

    @Override
    public boolean caresAboutManaColor() {
        return this.sunburst;
    }

    static {
        filter.add(CardType.CREATURE.getPredicate());
    }
}

