/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.StaticAbility;
import mage.abilities.hint.common.DayNightHint;
import mage.abilities.keyword.NightboundEffect;
import mage.cards.Card;
import mage.constants.Zone;
import mage.game.Game;

public class NightboundAbility
extends StaticAbility {
    public NightboundAbility() {
        super(Zone.BATTLEFIELD, new NightboundEffect());
        this.addHint(DayNightHint.instance);
    }

    private NightboundAbility(NightboundAbility ability) {
        super(ability);
    }

    @Override
    public String getRule() {
        return "nightbound <i>(If a player casts at least two spells during their own turn, it becomes day next turn.)</i>";
    }

    @Override
    public NightboundAbility copy() {
        return new NightboundAbility(this);
    }

    public static boolean checkCard(Card card, Game game) {
        return game.checkDayNight(false) && card.getSecondCardFace() != null && card.getSecondCardFace().getAbilities().containsClass(NightboundAbility.class);
    }
}

