/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.ReturnAttackerToHandTargetCost;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class NinjutsuEffect
extends OneShotEffect {
    private final boolean commander;

    NinjutsuEffect(boolean commander) {
        super(Outcome.PutCreatureInPlay);
        this.commander = commander;
        this.staticText = "Put this card onto the battlefield from your hand tapped and attacking";
    }

    private NinjutsuEffect(NinjutsuEffect effect) {
        super(effect);
        this.commander = effect.commander;
    }

    @Override
    public NinjutsuEffect copy() {
        return new NinjutsuEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card card = game.getCard(source.getSourceId());
        if (controller == null || card == null) {
            return false;
        }
        Zone cardZone = game.getState().getZone(card.getId());
        if (cardZone == Zone.HAND || this.commander && cardZone == Zone.COMMAND) {
            controller.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, false, null);
            Permanent permanent = game.getPermanent(source.getSourceId());
            if (permanent != null) {
                UUID defendingPlayerId = null;
                for (Cost cost : source.getCosts()) {
                    if (!(cost instanceof ReturnAttackerToHandTargetCost)) continue;
                    defendingPlayerId = ((ReturnAttackerToHandTargetCost)cost).getDefendingPlayerId();
                }
                if (defendingPlayerId != null) {
                    game.getCombat().addAttackerToCombat(permanent.getId(), defendingPlayerId, game);
                    return true;
                }
            }
        }
        return false;
    }
}

