/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.AbilityWord;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

public class PackTacticsAbility
extends TriggeredAbilityImpl {
    public PackTacticsAbility(Effect effect) {
        super(Zone.BATTLEFIELD, effect, false);
        this.withRuleTextReplacement(false);
        this.setAbilityWord(AbilityWord.PACK_TACTICS);
        this.setTriggerPhrase("Whenever {this} attacks, if you attacked with creatures with total power 6 or greater this combat, ");
    }

    private PackTacticsAbility(PackTacticsAbility ability) {
        super(ability);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ATTACKER_DECLARED;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        if (this.getSourceId().equals(event.getSourceId())) {
            int power = 0;
            for (UUID attackerId : game.getCombat().getAttackers()) {
                Permanent attacker = game.getPermanent(attackerId);
                if (attacker == null) continue;
                power += attacker.getPower().getValue();
            }
            return power >= 6;
        }
        return false;
    }

    @Override
    public PackTacticsAbility copy() {
        return new PackTacticsAbility(this);
    }
}

