/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.ObjectColor;
import mage.abilities.StaticAbility;
import mage.cards.Card;
import mage.constants.Zone;
import mage.filter.Filter;
import mage.filter.FilterCard;
import mage.filter.FilterObject;
import mage.filter.FilterPermanent;
import mage.filter.FilterPlayer;
import mage.filter.FilterSpell;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;
import mage.game.permanent.token.Token;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.util.CardUtil;

public class ProtectionAbility
extends StaticAbility {
    protected Filter filter;
    protected boolean removeAuras;
    protected boolean removeEquipment;
    protected boolean doesntRemoveControlled;
    protected ObjectColor fromColor;
    protected UUID auraIdNotToBeRemoved;
    private String staticText;

    public ProtectionAbility(Filter filter) {
        super(Zone.BATTLEFIELD, null);
        this.filter = filter;
        this.removeAuras = true;
        this.removeEquipment = true;
        this.doesntRemoveControlled = false;
        this.fromColor = new ObjectColor();
        this.auraIdNotToBeRemoved = null;
        this.staticText = null;
    }

    protected ProtectionAbility(ProtectionAbility ability) {
        super(ability);
        this.filter = ability.filter.copy();
        this.removeAuras = ability.removeAuras;
        this.removeEquipment = ability.removeEquipment;
        this.doesntRemoveControlled = ability.doesntRemoveControlled;
        this.fromColor = ability.fromColor;
        this.auraIdNotToBeRemoved = ability.auraIdNotToBeRemoved;
        this.staticText = ability.staticText;
    }

    public static ProtectionAbility from(ObjectColor color) {
        FilterObject<MageObject> filter = new FilterObject<MageObject>(ProtectionAbility.getFilterText(color));
        filter.add(new ColorPredicate(color));
        ProtectionAbility ability = new ProtectionAbility(filter);
        ability.getFromColor().addColor(color);
        return ability;
    }

    public static ProtectionAbility from(ObjectColor color1, ObjectColor color2) {
        FilterObject<MageObject> filter = new FilterObject<MageObject>(color1.getDescription() + " and from " + color2.getDescription());
        filter.add(Predicates.or(new ColorPredicate(color1), new ColorPredicate(color2)));
        ProtectionAbility ability = new ProtectionAbility(filter);
        ability.getFromColor().addColor(color1);
        ability.getFromColor().addColor(color2);
        return ability;
    }

    @Override
    public ProtectionAbility copy() {
        return new ProtectionAbility(this);
    }

    @Override
    public String getRule() {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return this.addRulePrefix("protection from ") + this.filter.getMessage() + (this.removeAuras ? "" : ". This effect doesn't remove Auras.");
    }

    public ProtectionAbility setText(String text) {
        this.staticText = text;
        return this;
    }

    public boolean canTarget(MageObject source, Game game) {
        if (this.filter instanceof FilterPermanent) {
            if (source instanceof Permanent) {
                return !((FilterPermanent)this.filter).match((Permanent)source, game);
            }
            return true;
        }
        if (this.filter instanceof FilterCard) {
            if (source instanceof Card) {
                return !((FilterCard)this.filter).match((Card)source, ((Card)source).getControllerOrOwnerId(), this, game);
            }
            if (source instanceof Token) {
                PermanentToken fakePermanent = new PermanentToken((Token)source, UUID.randomUUID(), game);
                return !((FilterCard)this.filter).match(fakePermanent, game);
            }
            return true;
        }
        if (this.filter instanceof FilterSpell) {
            if (source instanceof Spell || game.inCheckPlayableState() && source.isInstantOrSorcery(game)) {
                return !this.filter.match(source, game);
            }
            return true;
        }
        if (this.filter instanceof FilterObject) {
            return !((FilterObject)this.filter).match(source, game);
        }
        if (this.filter instanceof FilterPlayer) {
            Player player = null;
            if (source instanceof Card) {
                player = game.getPlayer(((Card)source).getControllerOrOwnerId());
            } else if (source instanceof Token) {
                throw new IllegalArgumentException("Wrong code usage: token can't be checked in player restriction filter");
            }
            return !((FilterPlayer)this.filter).match(player, this.getControllerId(), this, game);
        }
        return true;
    }

    private static String getFilterText(ObjectColor color) {
        return CardUtil.concatWithAnd(color.getColors().stream().map(ObjectColor::getDescription).map(s -> "from " + s).collect(Collectors.toList())).replaceFirst("from ", "");
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(FilterCard filter) {
        this.filter = filter;
    }

    public void setRemovesAuras(boolean removeAuras) {
        this.removeAuras = removeAuras;
    }

    public boolean removesAuras() {
        return this.removeAuras;
    }

    public void setRemoveEquipment(boolean removeEquipment) {
        this.removeEquipment = removeEquipment;
    }

    public boolean removesEquipment() {
        return this.removeEquipment;
    }

    public void setDoesntRemoveControlled(boolean doesntRemoveControlled) {
        this.doesntRemoveControlled = doesntRemoveControlled;
    }

    public boolean getDoesntRemoveControlled() {
        return this.doesntRemoveControlled;
    }

    public ObjectColor getFromColor() {
        return this.fromColor;
    }

    public UUID getAuraIdNotToBeRemoved() {
        return this.auraIdNotToBeRemoved;
    }

    public void setAuraIdNotToBeRemoved(UUID auraIdNotToBeRemoved) {
        this.auraIdNotToBeRemoved = auraIdNotToBeRemoved;
    }
}

