/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RequirementEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ProvokeRequirementEffect
extends RequirementEffect {
    public ProvokeRequirementEffect() {
        this(Duration.EndOfTurn);
    }

    public ProvokeRequirementEffect(Duration duration) {
        super(duration);
        this.staticText = "and blocks {this} this turn if able";
    }

    protected ProvokeRequirementEffect(ProvokeRequirementEffect effect) {
        super(effect);
    }

    @Override
    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.getId().equals(this.getTargetPointer().getFirst(game, source));
    }

    @Override
    public boolean mustAttack(Game game) {
        return false;
    }

    @Override
    public boolean mustBlock(Game game) {
        return true;
    }

    @Override
    public UUID mustBlockAttacker(Ability source, Game game) {
        return source.getSourceId();
    }

    @Override
    public ProvokeRequirementEffect copy() {
        return new ProvokeRequirementEffect(this);
    }
}

