/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.costs.Cost;
import mage.abilities.keyword.RecoverEffect;
import mage.cards.Card;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;

public class RecoverAbility
extends TriggeredAbilityImpl {
    public RecoverAbility(Cost cost, Card card) {
        super(Zone.GRAVEYARD, new RecoverEffect(cost, card), false);
        this.setLeavesTheBattlefieldTrigger(true);
    }

    protected RecoverAbility(RecoverAbility ability) {
        super(ability);
    }

    @Override
    public RecoverAbility copy() {
        return new RecoverAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        return zEvent.isDiesEvent() && zEvent.getTarget().isOwnedBy(this.getControllerId()) && zEvent.getTarget().isCreature(game) && !zEvent.getTarget().getId().equals(this.getSourceId());
    }

    @Override
    public String getRule() {
        return super.getRule();
    }
}

