/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CommanderCardType;
import mage.game.Game;
import mage.game.command.CommandObject;
import mage.players.Player;
import mage.util.CardUtil;

class RevealNinjutsuCardCost
extends CostImpl {
    private final boolean commander;

    public RevealNinjutsuCardCost(boolean commander) {
        this.text = "reveal ninjutsu card";
        this.commander = commander;
    }

    public RevealNinjutsuCardCost(RevealNinjutsuCardCost cost) {
        super(cost);
        this.commander = cost.commander;
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Player player = game.getPlayer(controllerId);
        Card card = player.getHand().get(ability.getSourceId(), game);
        if (card == null && this.commander && game.getCommandersIds(player, CommanderCardType.COMMANDER_OR_OATHBREAKER, true).contains(ability.getSourceId())) {
            for (CommandObject coj : game.getState().getCommand()) {
                if (coj == null || !coj.getId().equals(ability.getSourceId()) || !CardUtil.getObjectParts(coj).contains(ability.getSourceId())) continue;
                card = game.getCard(CardUtil.getMainCardId(game, ability.getSourceId()));
                break;
            }
        }
        if (card != null) {
            CardsImpl cards = new CardsImpl(card);
            player.revealCards("Ninjutsu", (Cards)cards, game);
            this.paid = true;
            return this.paid;
        }
        return false;
    }

    @Override
    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        return true;
    }

    @Override
    public RevealNinjutsuCardCost copy() {
        return new RevealNinjutsuCardCost(this);
    }
}

