/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class SetClassLevelEffect
extends OneShotEffect {
    private final int level;

    SetClassLevelEffect(int level) {
        super(Outcome.Benefit);
        this.level = level;
        this.staticText = "level up to " + level;
    }

    private SetClassLevelEffect(SetClassLevelEffect effect) {
        super(effect);
        this.level = effect.level;
    }

    @Override
    public SetClassLevelEffect copy() {
        return new SetClassLevelEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null || !permanent.isPhasedIn()) {
            return false;
        }
        int oldLevel = permanent.getClassLevel();
        if (!permanent.setClassLevel(this.level)) {
            return false;
        }
        game.informPlayers(permanent.getLogName() + " levelled up from " + oldLevel + " to " + permanent.getClassLevel());
        game.fireEvent(GameEvent.getEvent(GameEvent.EventType.GAINS_CLASS_LEVEL, source.getSourceId(), source, source.getControllerId(), this.level));
        return true;
    }
}

