/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.PairedPredicate;
import mage.constants.Outcome;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SoulboundEntersOtherEffect
extends OneShotEffect {
    private static final FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent("another not paired creature you control");

    public SoulboundEntersOtherEffect() {
        super(Outcome.Benefit);
    }

    protected SoulboundEntersOtherEffect(SoulboundEntersOtherEffect effect) {
        super(effect);
    }

    @Override
    public SoulboundEntersOtherEffect copy() {
        return new SoulboundEntersOtherEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null && permanent.getPairedCard() == null && permanent.isCreature(game)) {
            Permanent enteringPermanent;
            Player controller = game.getPlayer(permanent.getControllerId());
            if (controller != null && (enteringPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source))) != null && enteringPermanent.isCreature(game) && enteringPermanent.getPairedCard() == null) {
                enteringPermanent.setPairedCard(new MageObjectReference(permanent, game));
                permanent.setPairedCard(new MageObjectReference(enteringPermanent, game));
                if (!game.isSimulation()) {
                    game.informPlayers(controller.getLogName() + " soulbonds " + permanent.getLogName() + " with " + enteringPermanent.getLogName());
                }
            }
            return true;
        }
        return false;
    }

    static {
        filter.add(AnotherPredicate.instance);
        filter.add(Predicates.not(new PairedPredicate()));
    }
}

