/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.PairedPredicate;
import mage.constants.Outcome;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetControlledPermanent;
import mage.util.GameLog;

class SoulboundEntersSelfEffect
extends OneShotEffect {
    private static final FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent("another not paired creature you control");

    public SoulboundEntersSelfEffect() {
        super(Outcome.Benefit);
    }

    protected SoulboundEntersSelfEffect(SoulboundEntersSelfEffect effect) {
        super(effect);
    }

    @Override
    public SoulboundEntersSelfEffect copy() {
        return new SoulboundEntersSelfEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null && permanent.isCreature(game)) {
            Player controller = game.getPlayer(permanent.getControllerId());
            if (controller != null) {
                Permanent chosen;
                TargetControlledPermanent target = new TargetControlledPermanent(filter);
                target.withNotTarget(true);
                if (target.canChoose(controller.getId(), source, game) && controller.choose(Outcome.Benefit, target, source, game) && (chosen = game.getPermanent(target.getFirstTarget())) != null) {
                    chosen.setPairedCard(new MageObjectReference(permanent, game));
                    chosen.addInfo("soulbond", "Soulbond to " + GameLog.getColoredObjectIdNameForTooltip(permanent), game);
                    permanent.setPairedCard(new MageObjectReference(chosen, game));
                    permanent.addInfo("soulbond", "Soulbond to " + GameLog.getColoredObjectIdNameForTooltip(chosen), game);
                    if (!game.isSimulation()) {
                        game.informPlayers(controller.getLogName() + " soulbonds " + permanent.getLogName() + " with " + chosen.getLogName());
                    }
                }
            }
            return true;
        }
        return false;
    }

    static {
        filter.add(AnotherPredicate.instance);
        filter.add(Predicates.not(new PairedPredicate()));
    }
}

