/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.MageSingleton;
import mage.abilities.effects.RestrictionEffect;
import mage.abilities.keyword.CanBlockSpaceflightAbility;
import mage.abilities.keyword.SpaceflightAbility;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SpaceFlightEffect
extends RestrictionEffect
implements MageSingleton {
    public SpaceFlightEffect() {
        super(Duration.EndOfGame);
    }

    protected SpaceFlightEffect(SpaceFlightEffect effect) {
        super(effect);
    }

    @Override
    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.getAbilities().containsKey(SpaceflightAbility.getInstance().getId());
    }

    @Override
    public boolean canBlock(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        if (attacker == null) {
            return true;
        }
        return attacker.getAbilities().containsKey(SpaceflightAbility.getInstance().getId());
    }

    @Override
    public boolean canBeBlocked(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        return blocker.getAbilities().containsKey(SpaceflightAbility.getInstance().getId()) || blocker.getAbilities().containsKey(CanBlockSpaceflightAbility.getInstance().getId());
    }

    @Override
    public SpaceFlightEffect copy() {
        return new SpaceFlightEffect(this);
    }
}

