/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.Set;
import java.util.UUID;
import mage.MageIdentifier;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.ActivatedAbility;
import mage.abilities.SpecialAction;
import mage.abilities.costs.VariableCostType;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.costs.mana.VariableManaCost;
import mage.abilities.effects.common.continuous.GainSuspendEffect;
import mage.abilities.keyword.SuspendExileEffect;
import mage.abilities.keyword.SuspendPlayCardAbility;
import mage.abilities.keyword.SuspendUpkeepAbility;
import mage.cards.Card;
import mage.cards.ModalDoubleFacedCard;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

public class SuspendAbility
extends SpecialAction {
    private final String ruleText;

    public SuspendAbility(int suspend, ManaCost cost, Card card) {
        this(suspend, cost, card, false);
    }

    public SuspendAbility(int suspend, ManaCost cost, Card card, boolean hideReminderText) {
        super(Zone.HAND);
        this.addCost(cost);
        this.addEffect(new SuspendExileEffect(suspend));
        this.usesStack = false;
        if (suspend == Integer.MAX_VALUE) {
            VariableManaCost xCosts = new VariableManaCost(VariableCostType.ALTERNATIVE);
            xCosts.setMinX(1);
            this.addCost(xCosts);
            cost = new ManaCostsImpl("{X}" + cost.getText());
        }
        if (cost != null) {
            this.ruleText = "Suspend " + (suspend == Integer.MAX_VALUE ? "X" : Integer.valueOf(suspend)) + "&mdash;" + cost.getText() + (suspend == Integer.MAX_VALUE ? ". X can't be 0." : "") + (hideReminderText ? "" : this.makeReminderText(suspend, cost.getText(), card.isCreature()));
            if (card.getManaCost().isEmpty()) {
                this.setRuleAtTheTop(true);
            }
            this.addSubAbility(new SuspendUpkeepAbility());
            this.addSubAbility(new SuspendPlayCardAbility());
        } else {
            this.ruleText = "Suspend";
        }
    }

    private String makeReminderText(int suspend, String costText, boolean isCreature) {
        String counterText;
        switch (suspend) {
            case 1: {
                counterText = "a time counter";
                break;
            }
            case 0x7FFFFFFF: {
                counterText = "X time counters";
                break;
            }
            default: {
                counterText = CardUtil.numberToText(suspend) + " time counters";
            }
        }
        return " <i>(Rather than cast this card from your hand, you may pay " + costText + " and exile it with " + counterText + " on it. At the beginning of your upkeep, remove a time counter. When the last is removed, you may cast it without paying its mana cost." + (isCreature ? " It has haste." : "") + ")</i>";
    }

    public static void addSuspendTemporaryToCard(Card card, Ability source, Game game) {
        if (card instanceof ModalDoubleFacedCard) {
            card = ((ModalDoubleFacedCard)card).getLeftHalfCard();
        }
        SuspendAbility ability = new SuspendAbility(0, null, card, false);
        ability.setSourceId(card.getId());
        ability.setControllerId(card.getOwnerId());
        game.getState().addOtherAbility(card, ability);
        SuspendUpkeepAbility ability1 = new SuspendUpkeepAbility();
        ability1.setSourceId(card.getId());
        ability1.setControllerId(card.getOwnerId());
        game.getState().addOtherAbility(card, ability1);
        SuspendPlayCardAbility ability2 = new SuspendPlayCardAbility();
        ability2.setSourceId(card.getId());
        ability2.setControllerId(card.getOwnerId());
        game.getState().addOtherAbility(card, ability2);
    }

    public static UUID getSuspendExileId(UUID controllerId, Game game) {
        UUID exileId = (UUID)game.getState().getValue("SuspendExileId" + controllerId.toString());
        if (exileId == null) {
            exileId = UUID.randomUUID();
            game.getState().setValue("SuspendExileId" + controllerId, exileId);
        }
        return exileId;
    }

    private SuspendAbility(SuspendAbility ability) {
        super(ability);
        this.ruleText = ability.ruleText;
    }

    @Override
    public ActivatedAbility.ActivationStatus canActivate(UUID playerId, Game game) {
        if (game.getState().getZone(this.getSourceId()) != Zone.HAND) {
            return ActivatedAbility.ActivationStatus.getFalse();
        }
        Card card = game.getCard(this.getSourceId());
        if (card == null) {
            return ActivatedAbility.ActivationStatus.getFalse();
        }
        Set<MageIdentifier> allowedToBeCastNow = card.getSpellAbility().spellCanBeActivatedNow(playerId, game);
        if (!allowedToBeCastNow.contains((Object)MageIdentifier.Default) && !allowedToBeCastNow.contains((Object)card.getSpellAbility().getIdentifier())) {
            return ActivatedAbility.ActivationStatus.getFalse();
        }
        return super.canActivate(playerId, game);
    }

    public static boolean addTimeCountersAndSuspend(Card card, int amount, Ability source, Game game) {
        if (card == null || card.isCopy()) {
            return false;
        }
        if (!Zone.EXILED.match(game.getState().getZone(card.getId()))) {
            return false;
        }
        Player owner = game.getPlayer(card.getOwnerId());
        if (owner == null) {
            return false;
        }
        game.getExile().moveToAnotherZone(card.getMainCard(), game, game.getExile().createZone(SuspendAbility.getSuspendExileId(owner.getId(), game), "Suspended cards of " + owner.getName()));
        if (amount > 0) {
            card.addCounters(CounterType.TIME.createInstance(amount), owner.getId(), source, game);
        }
        if (!card.getAbilities(game).containsClass(SuspendAbility.class)) {
            game.addEffect(new GainSuspendEffect(new MageObjectReference(card, game)), source);
        }
        game.informPlayers(owner.getLogName() + " suspends " + amount + " - " + card.getName());
        return true;
    }

    @Override
    public String getRule() {
        return this.ruleText;
    }

    @Override
    public SuspendAbility copy() {
        return new SuspendAbility(this);
    }
}

