/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.GainHasteEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.util.CardUtil;

class SuspendPlayCardEffect
extends OneShotEffect {
    SuspendPlayCardEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "you may play it without paying its mana cost if able. If you don't, it remains exiled";
    }

    protected SuspendPlayCardEffect(SuspendPlayCardEffect effect) {
        super(effect);
    }

    @Override
    public SuspendPlayCardEffect copy() {
        return new SuspendPlayCardEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(source.getSourceId());
        if (player == null || card == null) {
            return false;
        }
        if (!CardUtil.castSpellWithAttributesForFree(player, source, game, new CardsImpl(card = card.getMainCard()), StaticFilters.FILTER_CARD, null, true)) {
            return true;
        }
        if (card.isCreature(game)) {
            GainHasteEffect effect = new GainHasteEffect();
            effect.setTargetPointer(new FixedTarget(card.getId(), card.getZoneChangeCounter(game) + 1));
            game.addEffect(effect, source);
        }
        return true;
    }
}

