/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.keyword.TransformEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.SuperType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.MageObjectAttribute;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;
import mage.game.stack.Spell;
import mage.util.CardUtil;

public class TransformAbility
extends SimpleStaticAbility {
    public static final String VALUE_KEY_ENTER_TRANSFORMED = "EnterTransformed";

    public TransformAbility() {
        super(Zone.BATTLEFIELD, new TransformEffect());
    }

    private TransformAbility(TransformAbility ability) {
        super(ability);
    }

    @Override
    public TransformAbility copy() {
        return new TransformAbility(this);
    }

    @Override
    public String getRule() {
        return "";
    }

    public static boolean transformPermanent(Permanent permanent, Game game, Ability source) {
        MageObject sourceCard = TransformAbility.findSourceObjectForTransform(permanent);
        if (sourceCard == null) {
            return false;
        }
        permanent.setTransformed(true);
        permanent.setName(sourceCard.getName());
        permanent.getColor(game).setColor(sourceCard.getColor(game));
        permanent.getManaCost().clear();
        permanent.getManaCost().add(sourceCard.getManaCost().copy());
        permanent.removeAllCardTypes(game);
        for (CardType cardType : sourceCard.getCardType(game)) {
            permanent.addCardType(game, cardType);
        }
        permanent.removeAllSubTypes(game);
        permanent.copySubTypesFrom(game, sourceCard);
        permanent.removeAllSuperTypes(game);
        for (SuperType superType : sourceCard.getSuperType(game)) {
            permanent.addSuperType(game, superType);
        }
        CardUtil.copySetAndCardNumber(permanent, sourceCard);
        permanent.getAbilities().clear();
        for (Ability ability : sourceCard.getAbilities()) {
            permanent.addAbility(ability, source == null ? permanent.getId() : source.getSourceId(), game, true);
        }
        permanent.getPower().setModifiedBaseValue(sourceCard.getPower().getValue());
        permanent.getToughness().setModifiedBaseValue(sourceCard.getToughness().getValue());
        permanent.setStartingLoyalty(sourceCard.getStartingLoyalty());
        permanent.setStartingDefense(sourceCard.getStartingDefense());
        return true;
    }

    private static MageObject findSourceObjectForTransform(Permanent permanent) {
        if (permanent == null) {
            return null;
        }
        if (permanent.isCopy()) {
            return null;
        }
        if (permanent instanceof PermanentToken) {
            return ((PermanentToken)permanent).getToken().getBackFace();
        }
        return permanent.getSecondCardFace();
    }

    public static Card transformCardSpellStatic(Card mainSide, Card otherSide, Game game) {
        Card newCard = mainSide.copy();
        newCard.setName(otherSide.getName());
        newCard.getManaCost().clear();
        newCard.getManaCost().add(mainSide.getManaCost().copy());
        game.getState().getCardState(newCard.getId()).clearAbilities();
        for (Ability ability : otherSide.getAbilities()) {
            game.getState().addOtherAbility(newCard, ability);
        }
        newCard.getPower().setModifiedBaseValue(otherSide.getPower().getValue());
        newCard.getToughness().setModifiedBaseValue(otherSide.getToughness().getValue());
        return newCard;
    }

    public static void transformCardSpellDynamic(Spell spell, Card otherSide, Game game) {
        MageObjectAttribute moa = game.getState().getCreateMageObjectAttribute(spell.getCard(), game);
        moa.getColor().setColor(otherSide.getColor(game));
        moa.getCardType().clear();
        moa.getCardType().addAll(otherSide.getCardType(game));
        moa.getSuperType().clear();
        moa.getSuperType().addAll(otherSide.getSuperType(game));
        moa.getSubtype().clear();
        moa.getSubtype().addAll(otherSide.getSubtype(game));
        game.getState().getCardState(spell.getCard().getId()).clearAbilities();
        for (Ability ability : otherSide.getAbilities()) {
            game.getState().addOtherAbility(spell.getCard(), ability);
        }
    }
}

