/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.Collection;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class TransmuteEffect
extends OneShotEffect {
    TransmuteEffect() {
        super(Outcome.Benefit);
        this.staticText = "Transmute";
    }

    private TransmuteEffect(TransmuteEffect effect) {
        super(effect);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (sourceObject != null && controller != null) {
            FilterCard filter = new FilterCard("card with mana value " + sourceObject.getManaValue());
            filter.add(new ManaValuePredicate(ComparisonType.EQUAL_TO, sourceObject.getManaValue()));
            TargetCardInLibrary target = new TargetCardInLibrary(1, filter);
            if (controller.searchLibrary(target, source, game) && !target.getTargets().isEmpty()) {
                CardsImpl revealed = new CardsImpl((Collection<UUID>)target.getTargets());
                controller.revealCards(sourceObject.getIdName(), (Cards)revealed, game);
                controller.moveCards(revealed, Zone.HAND, source, game);
            }
            controller.shuffleLibrary(source, game);
            return true;
        }
        return false;
    }

    @Override
    public TransmuteEffect copy() {
        return new TransmuteEffect(this);
    }
}

