/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.common.DiesSourceTriggeredAbility;
import mage.abilities.effects.common.ReturnSourceFromGraveyardToBattlefieldEffect;
import mage.abilities.keyword.UndyingEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

public class UndyingAbility
extends DiesSourceTriggeredAbility {
    public UndyingAbility() {
        super(new UndyingEffect());
        this.addEffect(new ReturnSourceFromGraveyardToBattlefieldEffect(false, true));
    }

    protected UndyingAbility(UndyingAbility ability) {
        super(ability);
    }

    @Override
    public UndyingAbility copy() {
        return new UndyingAbility(this);
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent;
        return super.checkTrigger(event, game) && (!(permanent = (Permanent)game.getLastKnownInformation(event.getTargetId(), Zone.BATTLEFIELD)).getCounters(game).containsKey(CounterType.P1P1) || permanent.getCounters(game).getCount(CounterType.P1P1) == 0);
    }

    @Override
    public String getRule() {
        return "undying <i>(When this creature dies, if it had no +1/+1 counters on it, return it to the battlefield under its owner's control with a +1/+1 counter on it.)</i>";
    }
}

