/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class UnleashReplacementEffect
extends ReplacementEffectImpl {
    public UnleashReplacementEffect() {
        super(Duration.EndOfGame, Outcome.Detriment);
    }

    public UnleashReplacementEffect(UnleashReplacementEffect effect) {
        super(effect);
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getTargetId().equals(source.getSourceId());
    }

    @Override
    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent creature = ((EntersTheBattlefieldEvent)event).getTarget();
        Player controller = game.getPlayer(source.getControllerId());
        if (creature != null && controller != null && controller.chooseUse(this.outcome, "Unleash " + creature.getLogName() + '?', source, game)) {
            if (!game.isSimulation()) {
                game.informPlayers(controller.getLogName() + " unleashes " + creature.getName());
            }
            creature.addCounters(CounterType.P1P1.createInstance(), source.getControllerId(), source, game, event.getAppliedEffects());
        }
        return false;
    }

    @Override
    public String getText(Mode mode) {
        return this.staticText;
    }

    @Override
    public UnleashReplacementEffect copy() {
        return new UnleashReplacementEffect(this);
    }
}

