/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import mage.MageIdentifier;
import mage.MageObjectReference;
import mage.abilities.ActivatedAbility;
import mage.abilities.SpellAbility;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.keyword.WarpAbilityWatcher;
import mage.cards.Card;
import mage.constants.SpellAbilityType;
import mage.constants.TimingRule;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class WarpAbility
extends SpellAbility {
    public static final String WARP_ACTIVATION_VALUE_KEY = "warpActivation";
    private final boolean allowGraveyard;

    public WarpAbility(Card card, String manaString) {
        this(card, manaString, false);
    }

    public WarpAbility(Card card, String manaString, boolean allowGraveyard) {
        super(card.getSpellAbility());
        this.newId();
        this.setCardName(card.getName() + " with Warp");
        this.zone = Zone.HAND;
        this.spellAbilityType = SpellAbilityType.BASE_ALTERNATE;
        this.timing = TimingRule.SORCERY;
        this.clearManaCosts();
        this.clearManaCostsToPay();
        this.addCost(new ManaCostsImpl(manaString));
        this.setAdditionalCostsRuleVisible(false);
        this.allowGraveyard = allowGraveyard;
        this.addWatcher(new WarpAbilityWatcher());
    }

    private WarpAbility(WarpAbility ability) {
        super(ability);
        this.allowGraveyard = ability.allowGraveyard;
    }

    @Override
    public ActivatedAbility.ActivationStatus canActivate(UUID playerId, Game game) {
        switch (game.getState().getZone(this.getSourceId())) {
            case GRAVEYARD: {
                if (!this.allowGraveyard) break;
            }
            case HAND: {
                return super.canActivate(playerId, game);
            }
        }
        return ActivatedAbility.ActivationStatus.getFalse();
    }

    @Override
    public boolean activate(Game game, Set<MageIdentifier> allowedIdentifiers, boolean noMana) {
        if (!super.activate(game, allowedIdentifiers, noMana)) {
            return false;
        }
        this.setCostsTag(WARP_ACTIVATION_VALUE_KEY, null);
        return true;
    }

    @Override
    public WarpAbility copy() {
        return new WarpAbility(this);
    }

    @Override
    public String getRule() {
        StringBuilder sb = new StringBuilder("Warp");
        if (this.getCosts().isEmpty()) {
            sb.append(' ');
        } else {
            sb.append("&mdash;");
        }
        sb.append(this.getManaCosts().getText());
        if (!this.getCosts().isEmpty()) {
            sb.append(", ");
            sb.append(this.getCosts().getText());
            sb.append('.');
        }
        return sb.toString();
    }

    public static String makeWarpString(UUID playerId) {
        return playerId + "- Warped";
    }

    public static boolean checkIfPermanentWarped(Permanent permanent, Game game) {
        return permanent != null && game.getPermanentCostsTags().getOrDefault(new MageObjectReference(permanent, game, -1), Collections.emptyMap()).containsKey(WARP_ACTIVATION_VALUE_KEY);
    }
}

