/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.mana;

import mage.Mana;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.mana.DynamicManaEffect;
import mage.abilities.mana.ActivatedManaAbilityImpl;
import mage.constants.Zone;
import mage.game.Game;

public class DynamicManaAbility
extends ActivatedManaAbilityImpl {
    private DynamicManaEffect manaEffect;
    private String rule;

    public DynamicManaAbility(Mana mana, DynamicValue amount) {
        this(mana, amount, (Cost)new TapSourceCost());
    }

    public DynamicManaAbility(Mana mana, DynamicValue amount, String text) {
        this(mana, amount, new TapSourceCost(), text);
    }

    public DynamicManaAbility(Mana mana, DynamicValue amount, Cost cost) {
        this(mana, amount, cost, null);
    }

    public DynamicManaAbility(Mana mana, DynamicValue amount, Cost cost, String text) {
        this(mana, amount, cost, text, false);
    }

    public DynamicManaAbility(Mana mana, DynamicValue amount, Cost cost, String text, boolean oneChoice) {
        this(mana, amount, cost, text, oneChoice, null);
    }

    public DynamicManaAbility(Mana mana, DynamicValue amount, Cost cost, String text, boolean oneChoice, DynamicValue netAmount) {
        super(Zone.BATTLEFIELD, new DynamicManaEffect(mana, amount, text, oneChoice, netAmount), cost);
        this.manaEffect = (DynamicManaEffect)this.getEffects().get(0);
    }

    protected DynamicManaAbility(DynamicManaAbility ability) {
        super(ability);
        this.manaEffect = ability.manaEffect;
        this.rule = ability.rule;
    }

    @Override
    public DynamicManaAbility copy() {
        return new DynamicManaAbility(this);
    }

    @Override
    public boolean definesMana(Game game) {
        return true;
    }
}

