/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.mana;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import mage.ConditionalMana;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.mana.ActivatedManaAbilityImpl;
import mage.abilities.mana.ManaAbility;
import mage.constants.ManaType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ManaEvent;
import mage.game.events.TappedForManaEvent;
import mage.players.Player;
import org.apache.log4j.Logger;

public class ManaOptions
extends LinkedHashSet<Mana> {
    private static final Logger logger = Logger.getLogger(ManaOptions.class);

    public ManaOptions() {
    }

    protected ManaOptions(ManaOptions options) {
        for (Mana mana : options) {
            this.add(mana.copy());
        }
    }

    public void addMana(List<ActivatedManaAbilityImpl> abilities, Game game) {
        block9: {
            block7: {
                List<Mana> netManas;
                block8: {
                    if (this.isEmpty()) {
                        this.add(new Mana());
                    }
                    if (abilities.isEmpty()) {
                        return;
                    }
                    if (abilities.size() != 1) break block7;
                    netManas = abilities.get(0).getNetMana(game);
                    if (netManas.size() != 1) break block8;
                    this.checkManaReplacementAndTriggeredMana(abilities.get(0), game, netManas.get(0));
                    this.addMana(netManas.get(0));
                    this.addTriggeredMana(game, abilities.get(0));
                    break block9;
                }
                if (netManas.size() <= 1) break block9;
                this.addManaVariation(netManas, abilities.get(0), game);
                break block9;
            }
            ArrayList<Mana> copy = new ArrayList<Mana>(this);
            this.clear();
            for (ActivatedManaAbilityImpl ability : abilities) {
                for (Mana netMana : ability.getNetMana(game)) {
                    this.checkManaReplacementAndTriggeredMana(ability, game, netMana);
                    for (Mana triggeredManaVariation : ManaOptions.getTriggeredManaVariations(game, ability, netMana)) {
                        block3: for (Mana mana : copy) {
                            Mana newMana = new Mana();
                            newMana.add(mana);
                            newMana.add(triggeredManaVariation);
                            for (Mana existingMana : this) {
                                if (existingMana.equalManaValue(newMana)) continue block3;
                                Mana moreValuable = Mana.getMoreValuableMana(newMana, existingMana);
                                if (moreValuable == null) continue;
                                existingMana.setToMana(moreValuable);
                                continue block3;
                            }
                            this.add(newMana);
                        }
                    }
                }
            }
        }
    }

    private void addManaVariation(List<Mana> netManas, ActivatedManaAbilityImpl ability, Game game) {
        ArrayList<Mana> copy = new ArrayList<Mana>(this);
        this.clear();
        for (Mana netMana : netManas) {
            for (Mana mana : copy) {
                if (ability.hasTapCost() && !this.checkManaReplacementAndTriggeredMana(ability, game, netMana)) continue;
                Mana newMana = mana.copy();
                newMana.add(netMana);
                this.add(newMana);
            }
        }
    }

    private static List<List<Mana>> getSimulatedTriggeredManaFromPlayer(Game game, Ability ability) {
        Player player = game.getPlayer(ability.getControllerId());
        ArrayList<List<Mana>> newList = new ArrayList<List<Mana>>();
        if (player != null) {
            newList.addAll(player.getAvailableTriggeredMana());
            player.getAvailableTriggeredMana().clear();
        }
        return newList;
    }

    private boolean checkManaReplacementAndTriggeredMana(Ability ability, Game game, Mana mana) {
        if (ability.hasTapCost()) {
            TappedForManaEvent event = new TappedForManaEvent(ability.getSourceId(), ability, ability.getControllerId(), mana, game);
            if (game.replaceEvent(event)) {
                return false;
            }
            game.fireEvent(event);
        }
        ManaEvent manaEvent = new ManaEvent(GameEvent.EventType.MANA_ADDED, ability.getSourceId(), ability, ability.getControllerId(), mana);
        manaEvent.setData(mana.toString());
        game.fireEvent(manaEvent);
        return true;
    }

    public boolean addManaWithCost(List<ActivatedManaAbilityImpl> abilities, Game game) {
        boolean wasUsable = false;
        if (this.isEmpty()) {
            this.add(new Mana());
        }
        if (!abilities.isEmpty()) {
            if (abilities.size() == 1) {
                List<Mana> netManas = abilities.get(0).getNetMana(game);
                if (!netManas.isEmpty()) {
                    ActivatedManaAbilityImpl ability = abilities.get(0);
                    if (ability.getManaCosts().isEmpty()) {
                        if (netManas.size() == 1) {
                            this.checkManaReplacementAndTriggeredMana(ability, game, netManas.get(0));
                            this.addMana(netManas.get(0));
                            this.addTriggeredMana(game, ability);
                        } else {
                            ArrayList<Mana> copy = new ArrayList<Mana>(this);
                            this.clear();
                            for (Mana netMana : netManas) {
                                this.checkManaReplacementAndTriggeredMana(ability, game, netMana);
                                for (Mana triggeredManaVariation : ManaOptions.getTriggeredManaVariations(game, ability, netMana)) {
                                    for (Mana mana : copy) {
                                        Mana newMana = mana.copy();
                                        newMana.add(triggeredManaVariation);
                                        this.add(newMana);
                                        wasUsable = true;
                                    }
                                }
                            }
                        }
                    } else {
                        ArrayList<Mana> copy = new ArrayList<Mana>(this);
                        this.clear();
                        Mana manaCosts = ability.getManaCosts().getMana();
                        for (Mana netMana : netManas) {
                            this.checkManaReplacementAndTriggeredMana(ability, game, netMana);
                            for (Mana triggeredManaVariation : ManaOptions.getTriggeredManaVariations(game, ability, netMana)) {
                                for (Mana startingMana : copy) {
                                    if (startingMana.includesMana(manaCosts)) {
                                        if (!this.subtractCostAddMana(manaCosts, triggeredManaVariation, ability.getCosts().isEmpty(), startingMana, ability, game)) {
                                            this.add(startingMana);
                                        }
                                        wasUsable = true;
                                        continue;
                                    }
                                    this.add(startingMana);
                                }
                            }
                        }
                    }
                }
            } else {
                ArrayList<Mana> copy = new ArrayList<Mana>(this);
                this.clear();
                for (ActivatedManaAbilityImpl ability : abilities) {
                    List<Mana> netManas = ability.getNetMana(game);
                    if (ability.getManaCosts().isEmpty()) {
                        for (Mana netMana : netManas) {
                            this.checkManaReplacementAndTriggeredMana(ability, game, netMana);
                            for (Mana triggeredManaVariation : ManaOptions.getTriggeredManaVariations(game, ability, netMana)) {
                                for (Mana mana : copy) {
                                    Mana newMana = mana.copy();
                                    newMana.add(triggeredManaVariation);
                                    this.add(newMana);
                                    wasUsable = true;
                                }
                            }
                        }
                        continue;
                    }
                    for (Mana netMana : netManas) {
                        this.checkManaReplacementAndTriggeredMana(ability, game, netMana);
                        for (Mana triggeredManaVariation : ManaOptions.getTriggeredManaVariations(game, ability, netMana)) {
                            for (Mana previousMana : copy) {
                                for (Mana manaOption : ability.getManaCosts().getManaOptions()) {
                                    if (!previousMana.includesMana(manaOption)) continue;
                                    wasUsable |= this.subtractCostAddMana(manaOption, triggeredManaVariation, ability.getCosts().isEmpty(), previousMana, ability, game);
                                }
                            }
                        }
                    }
                }
            }
        }
        if (logger.isTraceEnabled() && this.size() > 30) {
            logger.trace((Object)("ManaOptionsCosts " + this.size()));
            logger.trace((Object)("Abilities: " + abilities.toString()));
        }
        return wasUsable;
    }

    public boolean addManaPoolDependant(List<ActivatedManaAbilityImpl> abilities, Game game) {
        if (abilities.isEmpty() || abilities.size() != 1) {
            return false;
        }
        boolean wasUsable = false;
        ActivatedManaAbilityImpl ability = abilities.get(0);
        Mana manaCosts = ability.getManaCosts().getMana();
        ManaOptions copy = this.copy();
        this.clear();
        for (Mana previousMana : copy) {
            if (previousMana.includesMana(manaCosts)) {
                for (Mana manaOption : ability.getManaCosts().getManaOptions()) {
                    if (this.subtractCostAddMana(manaOption, null, ability.getCosts().isEmpty(), previousMana, ability, game)) continue;
                    this.add(previousMana);
                }
                wasUsable = true;
                continue;
            }
            this.add(previousMana);
        }
        return wasUsable;
    }

    public static List<Mana> getTriggeredManaVariations(Game game, Ability ability, Mana baseMana) {
        ArrayList<Mana> baseManaPlusTriggeredMana = new ArrayList<Mana>();
        baseManaPlusTriggeredMana.add(baseMana);
        List<List<Mana>> availableTriggeredManaList = ManaOptions.getSimulatedTriggeredManaFromPlayer(game, ability);
        for (List<Mana> availableTriggeredMana : availableTriggeredManaList) {
            if (availableTriggeredMana.size() == 1) {
                for (Mana prevMana : baseManaPlusTriggeredMana) {
                    prevMana.add(availableTriggeredMana.get(0));
                }
                continue;
            }
            if (availableTriggeredMana.size() <= 1) continue;
            ArrayList<Mana> copy = new ArrayList<Mana>(baseManaPlusTriggeredMana);
            baseManaPlusTriggeredMana.clear();
            for (Mana triggeredMana : availableTriggeredMana) {
                for (Mana prevMana : copy) {
                    Mana newMana = new Mana();
                    newMana.add(prevMana);
                    newMana.add(triggeredMana);
                    baseManaPlusTriggeredMana.add(newMana);
                }
            }
        }
        return baseManaPlusTriggeredMana;
    }

    private void addTriggeredMana(Game game, Ability ability) {
        List<List<Mana>> netManaList = ManaOptions.getSimulatedTriggeredManaFromPlayer(game, ability);
        for (List<Mana> triggeredNetMana : netManaList) {
            if (triggeredNetMana.size() == 1) {
                this.addMana(triggeredNetMana.get(0));
                continue;
            }
            if (triggeredNetMana.size() <= 1) continue;
            ArrayList<Mana> copy = new ArrayList<Mana>(this);
            this.clear();
            for (Mana triggeredMana : triggeredNetMana) {
                for (Mana mana : copy) {
                    Mana newMana = mana.copy();
                    newMana.add(triggeredMana);
                    this.add(newMana);
                }
            }
        }
    }

    public void addMana(Mana addMana) {
        if (this.isEmpty()) {
            this.add(new Mana());
        }
        if (addMana instanceof ConditionalMana) {
            ArrayList<Mana> copy = new ArrayList<Mana>(this);
            this.clear();
            for (Mana mana : copy) {
                ConditionalMana condMana = ((ConditionalMana)addMana).copy();
                condMana.add(mana);
                this.add(condMana);
                this.add(mana);
            }
        } else {
            for (Mana mana : this) {
                mana.add(addMana);
            }
        }
    }

    public void addMana(ManaOptions options) {
        if (this.isEmpty()) {
            this.add(new Mana());
        }
        if (!options.isEmpty()) {
            if (options.size() == 1) {
                this.addMana(options.getAtIndex(0));
            } else {
                ArrayList<Mana> copy = new ArrayList<Mana>(this);
                this.clear();
                for (Mana addMana : options) {
                    for (Mana mana : copy) {
                        Mana newMana = mana.copy();
                        newMana.add(addMana);
                        this.add(newMana);
                    }
                }
            }
        }
    }

    public ManaOptions copy() {
        return new ManaOptions(this);
    }

    private boolean subtractCostAddMana(Mana cost, Mana manaToAdd, boolean onlyManaCosts, Mana startingMana, ManaAbility manaAbility, Game game) {
        boolean oldManaWasReplaced = false;
        boolean repeatable = manaToAdd != null && onlyManaCosts && manaToAdd.countColored() > 0;
        int maxRepeat = manaAbility.getMaxMoreActivationsThisTurn(game);
        Mana possibleMana = new Mana();
        Mana improvedMana = new Mana();
        for (Mana possiblePay : ManaOptions.getPossiblePayCombinations(cost, startingMana)) {
            boolean canHaveBetterValues;
            improvedMana.setToMana(startingMana);
            int currentAttempt = 0;
            do {
                canHaveBetterValues = false;
                ++currentAttempt;
                possibleMana.setToMana(improvedMana);
                possibleMana.subtract(possiblePay);
                if (!possibleMana.isValid()) continue;
                List<Mana> addingManaOptions = manaToAdd != null ? Collections.singletonList(manaToAdd) : manaAbility.getNetMana(game, possibleMana);
                for (Mana addingMana : addingManaOptions) {
                    possibleMana.add(addingMana);
                    if (this.contains(possibleMana)) continue;
                    this.add(possibleMana.copy());
                    canHaveBetterValues = true;
                    if (possibleMana.isMoreValuableThan(improvedMana)) {
                        oldManaWasReplaced = true;
                        if (!startingMana.equalManaValue(improvedMana)) {
                            this.removeEqualMana(improvedMana);
                        }
                    }
                    improvedMana.setToMana(possibleMana);
                }
            } while (repeatable && currentAttempt < maxRepeat && canHaveBetterValues && improvedMana.includesMana(possiblePay));
        }
        return oldManaWasReplaced;
    }

    public static Set<Mana> getPossiblePayCombinations(Mana manaCost, Mana manaAvailable) {
        HashSet<Mana> payCombinations = new HashSet<Mana>();
        Mana fixedMana = manaCost.copy();
        if (manaCost.getGeneric() == 0) {
            payCombinations.add(fixedMana);
            return payCombinations;
        }
        fixedMana.setGeneric(0);
        Mana manaAfterFixedPayment = manaAvailable.copy();
        manaAfterFixedPayment.subtract(fixedMana);
        if (manaAvailable.countColored() == 0) {
            payCombinations.add(Mana.ColorlessMana(manaCost.getGeneric()));
        } else {
            ManaType[] manaTypes = ManaType.values();
            Mana manaToPayFrom = new Mana();
            for (int i = 0; i < manaCost.getGeneric(); ++i) {
                ArrayList<Mana> existingManas = new ArrayList<Mana>(payCombinations.size());
                if (i > 0) {
                    existingManas.addAll(payCombinations);
                    payCombinations.clear();
                } else {
                    existingManas.add(new Mana());
                }
                for (Mana existingMana : existingManas) {
                    manaToPayFrom.setToMana(manaAfterFixedPayment);
                    manaToPayFrom.subtract(existingMana);
                    for (ManaType manaType : manaTypes) {
                        existingMana.increase(manaType);
                        if (manaToPayFrom.get(manaType) > 0 && !payCombinations.contains(existingMana)) {
                            payCombinations.add(existingMana.copy());
                            manaToPayFrom.decrease(manaType);
                        }
                        existingMana.decrease(manaType);
                    }
                    existingMana.increaseAny();
                    if (payCombinations.isEmpty() && manaToPayFrom.getAny() > 0) {
                        payCombinations.add(existingMana.copy());
                        manaToPayFrom.decreaseAny();
                    }
                    existingMana.decreaseAny();
                }
            }
        }
        for (Mana mana : payCombinations) {
            mana.add(fixedMana);
        }
        return payCombinations;
    }

    public boolean removeEqualMana(Mana manaToRemove) {
        boolean result = false;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Mana next = (Mana)iterator.next();
            if (!next.equalManaValue(manaToRemove)) continue;
            iterator.remove();
            result = true;
        }
        return result;
    }

    public void removeFullyIncludedVariations() {
        int i;
        ArrayList<Mana> that = new ArrayList<Mana>(this);
        HashSet<String> list = new HashSet<String>();
        for (i = this.size() - 1; i >= 0; --i) {
            String s = that.get(i) instanceof ConditionalMana ? ((Mana)that.get(i)).toString() + ((ConditionalMana)that.get(i)).getConditionString() : ((Mana)that.get(i)).toString();
            if (s.isEmpty()) {
                this.remove(i);
                continue;
            }
            if (list.contains(s)) {
                this.remove(i);
                continue;
            }
            list.add(s);
        }
        block1: for (i = this.size() - 1; i >= 0; --i) {
            for (int ii = 0; ii < i; ++ii) {
                Mana moreValuable = Mana.getMoreValuableMana((Mana)that.get(i), (Mana)that.get(ii));
                if (moreValuable == null) continue;
                ((Mana)that.get(ii)).setToMana(moreValuable);
                that.remove(i);
                continue block1;
            }
        }
        this.clear();
        this.addAll(that);
    }

    public boolean enough(Mana mana) {
        if (mana.count() == 0) {
            return true;
        }
        for (Mana avail : this) {
            if (!mana.enough(avail)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        Iterator it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            Mana mana = (Mana)it.next();
            sb.append(mana.toString());
            if (mana instanceof ConditionalMana) {
                sb.append(((ConditionalMana)mana).getConditionString());
            }
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    public Mana getAtIndex(int i) {
        if (i < 0 || i >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        Iterator itr = this.iterator();
        while (itr.hasNext()) {
            if (i == 0) {
                return (Mana)itr.next();
            }
            itr.next();
            --i;
        }
        return null;
    }
}

