/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.mana;

import java.util.ArrayList;
import java.util.List;
import mage.Mana;
import mage.abilities.costs.Cost;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.mana.BasicManaEffect;
import mage.abilities.effects.mana.ManaEffect;
import mage.abilities.mana.ActivatedManaAbilityImpl;
import mage.constants.Zone;
import mage.game.Game;

public class SimpleManaAbility
extends ActivatedManaAbilityImpl {
    private boolean predictable;

    public SimpleManaAbility(ManaEffect effect, Cost cost) {
        this(Zone.BATTLEFIELD, effect, cost);
    }

    public SimpleManaAbility(Zone zone, ManaEffect effect, Cost cost) {
        this(zone, effect, cost, true);
    }

    public SimpleManaAbility(Zone zone, ManaEffect effect, Cost cost, boolean predictable) {
        super(zone, effect, cost);
        this.predictable = predictable;
    }

    public SimpleManaAbility(Zone zone, Mana mana, Cost cost) {
        this(zone, mana, cost, null);
        this.netMana.add(mana.copy());
        this.predictable = true;
    }

    public SimpleManaAbility(Zone zone, Mana mana, Cost cost, DynamicValue netAmount) {
        super(zone, new BasicManaEffect(mana, netAmount), cost);
        this.netMana.add(mana.copy());
        this.predictable = true;
    }

    protected SimpleManaAbility(SimpleManaAbility ability) {
        super(ability);
        this.predictable = ability.predictable;
    }

    @Override
    public SimpleManaAbility copy() {
        return new SimpleManaAbility(this);
    }

    @Override
    public List<Mana> getNetMana(Game game) {
        if (this.predictable) {
            return super.getNetMana(game);
        }
        return new ArrayList<Mana>(this.netMana);
    }
}

