/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.mana;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mage.Mana;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.mana.ManaEffect;
import mage.abilities.mana.ManaAbility;
import mage.constants.AbilityType;
import mage.constants.ManaType;
import mage.constants.Zone;
import mage.game.Game;

public abstract class TriggeredManaAbility
extends TriggeredAbilityImpl
implements ManaAbility {
    protected List<Mana> netMana = new ArrayList<Mana>();
    protected boolean poolDependant;

    public TriggeredManaAbility(Zone zone, ManaEffect effect) {
        this(zone, effect, false);
    }

    public TriggeredManaAbility(Zone zone, ManaEffect effect, boolean optional) {
        super(zone, effect, optional);
        this.usesStack = false;
        this.abilityType = AbilityType.TRIGGERED_MANA;
    }

    protected TriggeredManaAbility(TriggeredManaAbility ability) {
        super(ability);
        this.netMana.addAll(ability.netMana);
        this.poolDependant = ability.poolDependant;
    }

    @Override
    public List<Mana> getNetMana(Game game) {
        if (game != null) {
            ArrayList<Mana> netMana = new ArrayList<Mana>();
            for (Effect effect : this.getEffects()) {
                if (!(effect instanceof ManaEffect)) continue;
                netMana.addAll(((ManaEffect)effect).getNetMana(game, this));
            }
            return netMana;
        }
        return new ArrayList<Mana>(this.netMana);
    }

    @Override
    public List<Mana> getNetMana(Game game, Mana possibleManaInPool) {
        if (this.isPoolDependant()) {
            ArrayList<Mana> poolDependantNetMana = new ArrayList<Mana>();
            for (Effect effect : this.getEffects()) {
                List<Mana> effectNetMana;
                if (!(effect instanceof ManaEffect) || (effectNetMana = ((ManaEffect)effect).getNetMana(game, possibleManaInPool, this)) == null) continue;
                poolDependantNetMana.addAll(effectNetMana);
            }
            return poolDependantNetMana;
        }
        return this.getNetMana(game);
    }

    @Override
    public Set<ManaType> getProducableManaTypes(Game game) {
        HashSet<ManaType> manaTypes = new HashSet<ManaType>();
        for (Effect effect : this.getEffects()) {
            if (!(effect instanceof ManaEffect)) continue;
            manaTypes.addAll(((ManaEffect)effect).getProducableManaTypes(game, this));
        }
        return manaTypes;
    }

    @Override
    public boolean definesMana(Game game) {
        return !this.netMana.isEmpty();
    }

    @Override
    public boolean isPoolDependant() {
        return this.poolDependant;
    }

    @Override
    public int getMaxMoreActivationsThisTurn(Game game) {
        return this.getRemainingTriggersLimitEachTurn(game);
    }

    @Override
    public TriggeredManaAbility setPoolDependant(boolean poolDependant) {
        this.poolDependant = poolDependant;
        return this;
    }
}

