/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.mana.conditional;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.condition.Condition;
import mage.abilities.costs.Cost;
import mage.abilities.mana.conditional.ManaCondition;
import mage.cards.Card;
import mage.filter.FilterSpell;
import mage.game.Game;
import mage.game.command.Commander;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;

class SpellCastManaCondition
extends ManaCondition
implements Condition {
    private final FilterSpell filter;

    public SpellCastManaCondition(FilterSpell filter) {
        this.filter = filter;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        if (source instanceof SpellAbility && !source.isActivated()) {
            MageObject object = game.getObject(source);
            if (object instanceof StackObject) {
                return this.filter.match((StackObject)object, source.getControllerId(), source, game);
            }
            if (game.inCheckPlayableState()) {
                Spell spell = null;
                if (object instanceof Card) {
                    spell = new Spell((Card)object, (SpellAbility)source, source.getControllerId(), game.getState().getZone(source.getSourceId()), game);
                } else if (object instanceof Commander) {
                    spell = new Spell(((Commander)object).getSourceObject(), (SpellAbility)source, source.getControllerId(), game.getState().getZone(source.getSourceId()), game);
                }
                return this.filter.match(spell, source.getControllerId(), source, game);
            }
        }
        return false;
    }

    @Override
    public boolean apply(Game game, Ability source, UUID originalId, Cost costToPay) {
        return this.apply(game, source);
    }
}

