/*
 * Decompiled with CFR 0.152.
 */
package mage.cards;

import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.Zone;
import mage.counters.Counter;
import mage.game.Game;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

public abstract class MeldCard
extends CardImpl {
    protected Card topHalfCard;
    protected Card bottomHalfCard;
    protected int topLastZoneChangeCounter;
    protected int bottomLastZoneChangeCounter;
    protected Cards halves;

    public MeldCard(UUID ownerId, CardSetInfo setInfo, CardType[] cardTypes, String costs) {
        super(ownerId, setInfo, cardTypes, costs);
        this.halves = new CardsImpl();
        this.nightCard = true;
    }

    protected MeldCard(MeldCard card) {
        super(card);
        this.topHalfCard = CardUtil.deepCopyObject(card.topHalfCard);
        this.bottomHalfCard = CardUtil.deepCopyObject(card.bottomHalfCard);
        this.topLastZoneChangeCounter = card.topLastZoneChangeCounter;
        this.bottomLastZoneChangeCounter = card.bottomLastZoneChangeCounter;
        this.halves = new CardsImpl(card.halves);
    }

    @Override
    public abstract MeldCard copy();

    public void setMelded(boolean isMelded, Game game) {
        game.getState().getCardState(this.getId()).setMelded(isMelded);
    }

    public boolean isMelded(Game game) {
        return game.getState().getCardState(this.getId()).isMelded();
    }

    public Card getTopHalfCard() {
        return this.topHalfCard;
    }

    public void setTopHalfCard(Card topHalfCard, Game game) {
        this.topHalfCard = topHalfCard;
        this.topLastZoneChangeCounter = topHalfCard.getZoneChangeCounter(game);
        this.halves.add(topHalfCard.getId());
    }

    public int getTopLastZoneChangeCounter() {
        return this.topLastZoneChangeCounter;
    }

    public void setTopLastZoneChangeCounter(int topLastZoneChangeCounter) {
        this.topLastZoneChangeCounter = topLastZoneChangeCounter;
    }

    public Card getBottomHalfCard() {
        return this.bottomHalfCard;
    }

    public void setBottomHalfCard(Card bottomHalfCard, Game game) {
        this.bottomHalfCard = bottomHalfCard;
        this.bottomLastZoneChangeCounter = bottomHalfCard.getZoneChangeCounter(game);
        this.halves.add(bottomHalfCard.getId());
    }

    public int getBottomLastZoneChangeCounter() {
        return this.bottomLastZoneChangeCounter;
    }

    public void setBottomLastZoneChangeCounter(int bottomLastZoneChangeCounter) {
        this.bottomLastZoneChangeCounter = bottomLastZoneChangeCounter;
    }

    @Override
    public void assignNewId() {
        super.assignNewId();
        this.topHalfCard.assignNewId();
        this.bottomHalfCard.assignNewId();
    }

    @Override
    public void setOwnerId(UUID ownerId) {
        super.setOwnerId(ownerId);
        this.abilities.setControllerId(ownerId);
    }

    @Override
    public int getManaValue() {
        if (this.isCopy()) {
            return 0;
        }
        return (this.topHalfCard != null ? this.topHalfCard.getManaValue() : 0) + (this.bottomHalfCard != null ? this.bottomHalfCard.getManaValue() : 0);
    }

    @Override
    public boolean isTransformable() {
        return false;
    }

    @Override
    public boolean addCounters(Counter counter, UUID playerAddingCounters, Ability source, Game game, List<UUID> appliedEffects) {
        if (this.isMelded(game)) {
            return super.addCounters(counter, playerAddingCounters, source, game, appliedEffects);
        }
        boolean returnState = true;
        if (this.hasTopHalf(game)) {
            returnState |= this.topHalfCard.addCounters(counter, playerAddingCounters, source, game, appliedEffects);
        }
        if (this.hasBottomHalf(game)) {
            returnState |= this.bottomHalfCard.addCounters(counter, playerAddingCounters, source, game, appliedEffects);
        }
        return returnState;
    }

    public boolean hasTopHalf(Game game) {
        boolean value;
        boolean bl = value = this.topLastZoneChangeCounter == this.topHalfCard.getZoneChangeCounter(game) && this.halves.contains(this.topHalfCard.getId());
        if (!value) {
            this.halves.remove(this.topHalfCard);
        }
        return value;
    }

    public boolean hasBottomHalf(Game game) {
        boolean value;
        boolean bl = value = this.bottomLastZoneChangeCounter == this.bottomHalfCard.getZoneChangeCounter(game) && this.halves.contains(this.bottomHalfCard.getId());
        if (!value) {
            this.halves.remove(this.bottomHalfCard);
        }
        return value;
    }

    @Override
    public boolean moveToZone(Zone toZone, Ability source, Game game, boolean flag, List<UUID> appliedEffects) {
        return super.moveToZone(toZone, source, game, flag, appliedEffects);
    }

    @Override
    public void setZone(Zone zone, Game game) {
        super.setZone(zone, game);
    }

    @Override
    public boolean moveToExile(UUID exileId, String name, Ability source, Game game, List<UUID> appliedEffects) {
        return super.moveToExile(exileId, name, source, game, appliedEffects);
    }

    @Override
    public boolean removeFromZone(Game game, Zone fromZone, Ability source) {
        boolean bottomRemoved;
        boolean topRemoved;
        if (this.isCopy()) {
            return super.removeFromZone(game, fromZone, source);
        }
        if (this.isMelded(game) && fromZone == Zone.BATTLEFIELD) {
            Permanent permanent = game.getPermanent(this.objectId);
            return permanent != null && permanent.removeFromZone(game, fromZone, source);
        }
        boolean bl = topRemoved = this.hasTopHalf(game) && this.topHalfCard.removeFromZone(game, fromZone, source);
        if (!topRemoved) {
            this.halves.remove(this.topHalfCard);
        }
        boolean bl2 = bottomRemoved = this.hasBottomHalf(game) && this.bottomHalfCard.removeFromZone(game, fromZone, source);
        if (!bottomRemoved) {
            this.halves.remove(this.bottomHalfCard);
        }
        return topRemoved || bottomRemoved;
    }

    @Override
    public void updateZoneChangeCounter(Game game, ZoneChangeEvent event) {
        if (this.isCopy() || !this.isMelded(game)) {
            super.updateZoneChangeCounter(game, event);
            return;
        }
        super.updateZoneChangeCounter(game, event);
        if (this.topLastZoneChangeCounter == this.topHalfCard.getZoneChangeCounter(game) && this.halves.contains(this.topHalfCard.getId())) {
            this.topHalfCard.updateZoneChangeCounter(game, event);
            this.topLastZoneChangeCounter = this.topHalfCard.getZoneChangeCounter(game);
        }
        if (this.bottomLastZoneChangeCounter == this.bottomHalfCard.getZoneChangeCounter(game) && this.halves.contains(this.bottomHalfCard.getId())) {
            this.bottomHalfCard.updateZoneChangeCounter(game, event);
            this.bottomLastZoneChangeCounter = this.bottomHalfCard.getZoneChangeCounter(game);
        }
    }

    public Cards getHalves() {
        return this.halves;
    }
}

