/*
 * Decompiled with CFR 0.152.
 */
package mage.cards;

import java.util.List;
import java.util.UUID;
import mage.MageInt;
import mage.MageObject;
import mage.ObjectColor;
import mage.abilities.Abilities;
import mage.abilities.AbilitiesImpl;
import mage.abilities.Ability;
import mage.abilities.PlayLandAbility;
import mage.abilities.SpellAbility;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.costs.mana.ManaCosts;
import mage.cards.Card;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.CardWithHalves;
import mage.cards.ModalDoubleFacedCardHalf;
import mage.cards.ModalDoubleFacedCardHalfImpl;
import mage.constants.CardType;
import mage.constants.SpellAbilityType;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.constants.Zone;
import mage.counters.Counter;
import mage.counters.Counters;
import mage.game.Game;
import mage.game.GameState;
import mage.game.events.ZoneChangeEvent;
import mage.util.CardUtil;
import mage.util.SubTypes;

public abstract class ModalDoubleFacedCard
extends CardImpl
implements CardWithHalves {
    protected Card leftHalfCard;
    protected Card rightHalfCard;

    public ModalDoubleFacedCard(UUID ownerId, CardSetInfo setInfo, CardType[] typesLeft, SubType[] subTypesLeft, String costsLeft, String secondSideName, CardType[] typesRight, SubType[] subTypesRight, String costsRight) {
        this(ownerId, setInfo, new SuperType[0], typesLeft, subTypesLeft, costsLeft, secondSideName, new SuperType[0], typesRight, subTypesRight, costsRight);
    }

    public ModalDoubleFacedCard(UUID ownerId, CardSetInfo setInfo, SuperType[] superTypesLeft, CardType[] typesLeft, SubType[] subTypesLeft, String costsLeft, String secondSideName, SuperType[] superTypesRight, CardType[] typesRight, SubType[] subTypesRight, String costsRight) {
        super(ownerId, setInfo, typesLeft, costsLeft + costsRight, SpellAbilityType.MODAL);
        this.leftHalfCard = new ModalDoubleFacedCardHalfImpl(this.getOwnerId(), setInfo.copy(), superTypesLeft, typesLeft, subTypesLeft, costsLeft, this, SpellAbilityType.MODAL_LEFT);
        this.rightHalfCard = new ModalDoubleFacedCardHalfImpl(this.getOwnerId(), new CardSetInfo(secondSideName, setInfo), superTypesRight, typesRight, subTypesRight, costsRight, this, SpellAbilityType.MODAL_RIGHT);
    }

    public ModalDoubleFacedCard(ModalDoubleFacedCard card) {
        super(card);
        this.leftHalfCard = card.getLeftHalfCard().copy();
        ((ModalDoubleFacedCardHalf)this.leftHalfCard).setParentCard(this);
        this.rightHalfCard = card.rightHalfCard.copy();
        ((ModalDoubleFacedCardHalf)this.rightHalfCard).setParentCard(this);
    }

    @Override
    public ModalDoubleFacedCardHalf getLeftHalfCard() {
        return (ModalDoubleFacedCardHalf)this.leftHalfCard;
    }

    @Override
    public ModalDoubleFacedCardHalf getRightHalfCard() {
        return (ModalDoubleFacedCardHalf)this.rightHalfCard;
    }

    public void setParts(ModalDoubleFacedCardHalf leftHalfCard, ModalDoubleFacedCardHalf rightHalfCard) {
        this.leftHalfCard = leftHalfCard;
        leftHalfCard.setParentCard(this);
        this.rightHalfCard = rightHalfCard;
        rightHalfCard.setParentCard(this);
    }

    @Override
    public void assignNewId() {
        super.assignNewId();
        this.leftHalfCard.assignNewId();
        this.rightHalfCard.assignNewId();
    }

    @Override
    public void setCopy(boolean isCopy, MageObject copiedFrom) {
        super.setCopy(isCopy, copiedFrom);
        this.leftHalfCard.setCopy(isCopy, copiedFrom);
        this.rightHalfCard.setCopy(isCopy, copiedFrom);
    }

    private void setSideZones(Zone mainZone, Game game) {
        switch (mainZone) {
            case BATTLEFIELD: 
            case STACK: {
                throw new IllegalArgumentException("Wrong code usage: you must put to battlefield/stack only real side card (half), not main");
            }
        }
        game.setZone(this.leftHalfCard.getId(), mainZone);
        game.setZone(this.rightHalfCard.getId(), mainZone);
        ModalDoubleFacedCard.checkGoodZones(game, this);
    }

    @Override
    public boolean moveToZone(Zone toZone, Ability source, Game game, boolean flag, List<UUID> appliedEffects) {
        if (super.moveToZone(toZone, source, game, flag, appliedEffects)) {
            Zone currentZone = game.getState().getZone(this.getId());
            this.setSideZones(currentZone, game);
            return true;
        }
        return false;
    }

    @Override
    public void setZone(Zone zone, Game game) {
        super.setZone(zone, game);
        this.setSideZones(zone, game);
    }

    @Override
    public boolean moveToExile(UUID exileId, String name, Ability source, Game game, List<UUID> appliedEffects) {
        if (super.moveToExile(exileId, name, source, game, appliedEffects)) {
            Zone currentZone = game.getState().getZone(this.getId());
            this.setSideZones(currentZone, game);
            return true;
        }
        return false;
    }

    public static void checkGoodZones(Game game, ModalDoubleFacedCard card) {
        Zone needZoneRight;
        Zone needZoneLeft;
        ModalDoubleFacedCardHalf leftPart = card.getLeftHalfCard();
        ModalDoubleFacedCardHalf rightPart = card.getRightHalfCard();
        Zone zoneMain = game.getState().getZone(card.getId());
        Zone zoneLeft = game.getState().getZone(leftPart.getId());
        Zone zoneRight = game.getState().getZone(rightPart.getId());
        switch (zoneMain) {
            case BATTLEFIELD: 
            case STACK: {
                if (zoneMain == zoneLeft) {
                    needZoneLeft = zoneMain;
                    needZoneRight = Zone.OUTSIDE;
                    break;
                }
                if (zoneMain == zoneRight) {
                    needZoneLeft = Zone.OUTSIDE;
                    needZoneRight = zoneMain;
                    break;
                }
                needZoneLeft = zoneMain;
                needZoneRight = Zone.OUTSIDE;
                break;
            }
            default: {
                needZoneLeft = zoneMain;
                needZoneRight = zoneMain;
            }
        }
        if (zoneLeft != needZoneLeft || zoneRight != needZoneRight) {
            throw new IllegalStateException("Wrong code usage: MDF card uses wrong zones - " + card + "\r\n" + String.format("* main zone: %s", new Object[]{zoneMain}) + "\r\n" + String.format("* left side: need %s, actual %s", new Object[]{needZoneLeft, zoneLeft}) + "\r\n" + String.format("* right side: need %s, actual %s", new Object[]{needZoneRight, zoneRight}));
        }
    }

    @Override
    public boolean removeFromZone(Game game, Zone fromZone, Ability source) {
        return super.removeFromZone(game, fromZone, source);
    }

    @Override
    public void updateZoneChangeCounter(Game game, ZoneChangeEvent event) {
        if (this.isCopy()) {
            super.updateZoneChangeCounter(game, event);
            return;
        }
        super.updateZoneChangeCounter(game, event);
        this.leftHalfCard.updateZoneChangeCounter(game, event);
        this.rightHalfCard.updateZoneChangeCounter(game, event);
    }

    @Override
    public Counters getCounters(Game game) {
        return this.getCounters(game.getState());
    }

    @Override
    public Counters getCounters(GameState state) {
        return state.getCardState(this.leftHalfCard.getId()).getCounters();
    }

    @Override
    public boolean addCounters(Counter counter, UUID playerAddingCounters, Ability source, Game game, List<UUID> appliedEffects, boolean isEffect, int maxCounters) {
        return this.leftHalfCard.addCounters(counter, playerAddingCounters, source, game, appliedEffects, isEffect, maxCounters);
    }

    @Override
    public void removeCounters(String counterName, int amount, Ability source, Game game) {
        this.leftHalfCard.removeCounters(counterName, amount, source, game);
    }

    @Override
    public boolean cast(Game game, Zone fromZone, SpellAbility ability, UUID controllerId) {
        switch (ability.getSpellAbilityType()) {
            case MODAL_LEFT: {
                return this.leftHalfCard.cast(game, fromZone, ability, controllerId);
            }
            case MODAL_RIGHT: {
                return this.rightHalfCard.cast(game, fromZone, ability, controllerId);
            }
        }
        if (this.leftHalfCard.getSpellAbility() != null) {
            this.leftHalfCard.getSpellAbility().setControllerId(controllerId);
        }
        if (this.rightHalfCard.getSpellAbility() != null) {
            this.rightHalfCard.getSpellAbility().setControllerId(controllerId);
        }
        return super.cast(game, fromZone, ability, controllerId);
    }

    @Override
    public List<SuperType> getSuperType(Game game) {
        return this.leftHalfCard != null ? this.leftHalfCard.getSuperType(game) : this.supertype;
    }

    @Override
    public List<CardType> getCardType(Game game) {
        return this.leftHalfCard != null ? this.leftHalfCard.getCardType(game) : this.cardType;
    }

    @Override
    public SubTypes getSubtype() {
        return this.leftHalfCard != null ? this.leftHalfCard.getSubtype() : this.subtype;
    }

    @Override
    public SubTypes getSubtype(Game game) {
        return this.leftHalfCard != null ? this.leftHalfCard.getSubtype(game) : this.subtype;
    }

    @Override
    public boolean hasSubtype(SubType subtype, Game game) {
        return this.leftHalfCard.hasSubtype(subtype, game);
    }

    @Override
    public Abilities<Ability> getAbilities() {
        return this.getInnerAbilities(true, true);
    }

    @Override
    public Abilities<Ability> getInitAbilities() {
        return this.getInnerAbilities(false, false);
    }

    public Abilities<Ability> getSharedAbilities(Game game) {
        return new AbilitiesImpl<Ability>();
    }

    @Override
    public Abilities<Ability> getAbilities(Game game) {
        return this.getInnerAbilities(game, true, true);
    }

    private boolean isIgnoreDefaultAbility(Ability ability) {
        if (ability instanceof SpellAbility && ((SpellAbility)ability).getSpellAbilityType() == SpellAbilityType.MODAL) {
            return true;
        }
        return ability instanceof PlayLandAbility;
    }

    private Abilities<Ability> getInnerAbilities(Game game, boolean showLeftSide, boolean showRightSide) {
        AbilitiesImpl<Ability> allAbilites = new AbilitiesImpl<Ability>();
        for (Ability ability : super.getAbilities(game)) {
            if (this.isIgnoreDefaultAbility(ability)) continue;
            allAbilites.add(ability);
        }
        if (showLeftSide) {
            allAbilites.addAll(this.leftHalfCard.getAbilities(game));
        }
        if (showRightSide) {
            allAbilites.addAll(this.rightHalfCard.getAbilities(game));
        }
        return allAbilites;
    }

    private Abilities<Ability> getInnerAbilities(boolean showLeftSide, boolean showRightSide) {
        AbilitiesImpl<Ability> allAbilites = new AbilitiesImpl<Ability>();
        for (Ability ability : super.getAbilities()) {
            if (this.isIgnoreDefaultAbility(ability)) continue;
            allAbilites.add(ability);
        }
        if (showLeftSide) {
            allAbilites.addAll(this.leftHalfCard.getAbilities());
        }
        if (showRightSide) {
            allAbilites.addAll(this.rightHalfCard.getAbilities());
        }
        return allAbilites;
    }

    @Override
    public List<String> getRules() {
        return CardUtil.getCardRulesWithAdditionalInfo(this, this.getInnerAbilities(true, false), this.getInnerAbilities(true, true));
    }

    @Override
    public List<String> getRules(Game game) {
        return CardUtil.getCardRulesWithAdditionalInfo(game, this, this.getInnerAbilities(game, true, false), this.getInnerAbilities(game, true, true));
    }

    @Override
    public boolean hasAbility(Ability ability, Game game) {
        return super.hasAbility(ability, game);
    }

    @Override
    public ObjectColor getColor() {
        return this.leftHalfCard.getColor();
    }

    @Override
    public ObjectColor getColor(Game game) {
        return this.leftHalfCard.getColor(game);
    }

    @Override
    public ObjectColor getFrameColor(Game game) {
        return this.leftHalfCard.getFrameColor(game);
    }

    @Override
    public void setOwnerId(UUID ownerId) {
        super.setOwnerId(ownerId);
        this.abilities.setControllerId(ownerId);
        this.leftHalfCard.getAbilities().setControllerId(ownerId);
        this.leftHalfCard.setOwnerId(ownerId);
        this.rightHalfCard.getAbilities().setControllerId(ownerId);
        this.rightHalfCard.setOwnerId(ownerId);
    }

    @Override
    public ManaCosts<ManaCost> getManaCost() {
        return this.leftHalfCard.getManaCost();
    }

    @Override
    public int getManaValue() {
        return this.leftHalfCard.getManaValue();
    }

    @Override
    public MageInt getPower() {
        return this.leftHalfCard.getPower();
    }

    @Override
    public MageInt getToughness() {
        return this.leftHalfCard.getToughness();
    }
}

