/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.decks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mage.cards.Card;
import mage.cards.decks.Deck;
import mage.cards.decks.DeckValidator;
import mage.cards.decks.DeckValidatorErrorType;
import mage.cards.repository.CardInfo;
import mage.cards.repository.CardRepository;
import mage.constants.Rarity;
import org.apache.log4j.Logger;

public class Constructed
extends DeckValidator {
    private static final Logger logger = Logger.getLogger(Constructed.class);
    protected List<String> banned = new ArrayList<String>();
    protected List<String> restricted = new ArrayList<String>();
    protected List<String> setCodes = new ArrayList<String>();
    protected List<Rarity> rarities = new ArrayList<Rarity>();
    protected Set<String> singleCards = new HashSet<String>();

    protected Constructed(String name) {
        this(name, null);
    }

    protected Constructed(String name, String shortName) {
        super(name, shortName);
        this.banned.add("Adriana's Valor");
        this.banned.add("Advantageous Proclamation");
        this.banned.add("Assemble the Rank and Vile");
        this.banned.add("Backup Plan");
        this.banned.add("Brago's Favor");
        this.banned.add("Double Stroke");
        this.banned.add("Echoing Boon");
        this.banned.add("Emissary's Ploy");
        this.banned.add("Hired Heist");
        this.banned.add("Hold the Perimeter");
        this.banned.add("Hymn of the Wilds");
        this.banned.add("Immediate Action");
        this.banned.add("Incendiary Dissent");
        this.banned.add("Iterative Analysis");
        this.banned.add("Muzzio's Preparations");
        this.banned.add("Natural Unity");
        this.banned.add("Power Play");
        this.banned.add("Secrets of Paradise");
        this.banned.add("Secret Summoning");
        this.banned.add("Sentinel Dispatch");
        this.banned.add("Sovereign's Realm");
        this.banned.add("Summoner's Bond");
        this.banned.add("Unexpected Potential");
        this.banned.add("Weight Advantage");
        this.banned.add("Worldknit");
        this.banned.add("Chaos Orb");
        this.banned.add("Falling Star");
        this.banned.add("Shahrazad");
        this.banned.add("Amulet of Quoz");
        this.banned.add("Bronze Tablet");
        this.banned.add("Contract from Below");
        this.banned.add("Darkpact");
        this.banned.add("Demonic Attorney");
        this.banned.add("Jeweled Bird");
        this.banned.add("Rebirth");
        this.banned.add("Tempest Efreet");
        this.banned.add("Timmerian Fiends");
        this.banned.add("Cleanse");
        this.banned.add("Crusade");
        this.banned.add("Imprison");
        this.banned.add("Invoke Prejudice");
        this.banned.add("Jihad");
        this.banned.add("Pradesh Gypsies");
        this.banned.add("Stone-Throwing Devils");
        this.banned.add("\"Brims\" Barone, Midway Mobster");
        this.banned.add("A Real Handful");
        this.banned.add("Aardwolf's Advantage");
        this.banned.add("Alpha Guard");
        this.banned.add("Amped Up");
        this.banned.add("An Incident Has Occurred");
        this.banned.add("Angelic Harold");
        this.banned.add("Animate Graveyard");
        this.banned.add("Animate Object");
        this.banned.add("Art Appreciation");
        this.banned.add("Assembled Ensemble");
        this.banned.add("Astroquarium");
        this.banned.add("Autograph Book");
        this.banned.add("Bag Check");
        this.banned.add("Bar Entry");
        this.banned.add("Blue Ribbon");
        this.banned.add("Blufferfish");
        this.banned.add("Busted!");
        this.banned.add("Carnival Barker");
        this.banned.add("Centrifuge");
        this.banned.add("Claire D'Loon, Joy Sculptor");
        this.banned.add("Cover the Spot");
        this.banned.add("D00-DL, Caricaturist");
        this.banned.add("Dart Throw");
        this.banned.add("Decisions, Decisions");
        this.banned.add("Devil K. Nevil");
        this.banned.add("Disemvowel");
        this.banned.add("Don't Try This at Home");
        this.banned.add("Exit Through the Grift Shop");
        this.banned.add("Far Out");
        this.banned.add("Fluros of Myra's Marvels");
        this.banned.add("Focused Funambulist");
        this.banned.add("Form of the Approach of the Second Sun");
        this.banned.add("Gallery of Legends");
        this.banned.add("Get Your Head in the Game");
        this.banned.add("Gift Shop");
        this.banned.add("Goblin Blastronauts");
        this.banned.add("Goblin Cruciverbalist");
        this.banned.add("Goblin Girder Gang");
        this.banned.add("Gobsmacked");
        this.banned.add("Grand Marshal Macie");
        this.banned.add("Gray Merchant of Alphabet");
        this.banned.add("Greatest Show in the Multiverse");
        this.banned.add("Guess Your Fate");
        this.banned.add("Haberthrasher");
        this.banned.add("Hardy of Myra's Marvels");
        this.banned.add("Hat Trick");
        this.banned.add("How Is This a Par Three?!");
        this.banned.add("Icing Manipulator");
        this.banned.add("Ignacio of Myra's Marvels");
        this.banned.add("Impounding Lot-Bot");
        this.banned.add("It Came from Planet Glurg");
        this.banned.add("Jermane, Pride of the Circus");
        this.banned.add("Jetpack Janitor");
        this.banned.add("Juggletron");
        this.banned.add("Katerina of Myra's Marvels");
        this.banned.add("Killer Cosplay");
        this.banned.add("Knife and Death");
        this.banned.add("Knight in _____ Armor");
        this.banned.add("Leading Performance");
        this.banned.add("Lila, Hospitality Hostess");
        this.banned.add("Log Flume");
        this.banned.add("Main Event Horizon");
        this.banned.add("Meet and Greet \"Sisay\"");
        this.banned.add("Memory Test");
        this.banned.add("Mistakes Were Made");
        this.banned.add("Mobile Clone");
        this.banned.add("Nearby Planet");
        this.banned.add("Nocturno of Myra's Marvels");
        this.banned.add("Now You See Me . . .");
        this.banned.add("Octo Opus");
        this.banned.add("Omniclown Colossus");
        this.banned.add("Opening Ceremony");
        this.banned.add("Park Map");
        this.banned.add("Park Re-Entry");
        this.banned.add("Phone a Friend");
        this.banned.add("Photo Op");
        this.banned.add("Pie-Eating Contest");
        this.banned.add("Pietra, Crafter of Clowns");
        this.banned.add("Plate Spinning");
        this.banned.add("Plot Armor");
        this.banned.add("Push Your Luck");
        this.banned.add("Questionable Cuisine");
        this.banned.add("Rat in the Hat");
        this.banned.add("Rock Star");
        this.banned.add("Scavenger Hunt");
        this.banned.add("Scooch");
        this.banned.add("Solaflora, Intergalactic Icon");
        this.banned.add("Sole Performer");
        this.banned.add("Souvenir T-Shirt");
        this.banned.add("Spelling Bee");
        this.banned.add("Squirrel Stack");
        this.banned.add("Standard Procedure");
        this.banned.add("Super-Duper Lost");
        this.banned.add("Surprise Party");
        this.banned.add("T.A.P.P.E.R.");
        this.banned.add("Tchotchke Elemental");
        this.banned.add("The Big Top");
        this.banned.add("The Superlatorium");
        this.banned.add("Ticking Mime Bomb");
        this.banned.add("Trapeze Artist");
        this.banned.add("Treacherous Trapezist");
        this.banned.add("Trigger Happy");
        this.banned.add("Trivia Contest");
        this.banned.add("Truss, Chief Engineer");
        this.banned.add("Tug of War");
        this.banned.add("Urza's Fun House");
        this.banned.add("Vorthos, Steward of Myth");
        this.banned.add("Water Gun Balloon Game");
        this.banned.add("Well Done");
    }

    public List<String> getSetCodes() {
        return this.setCodes;
    }

    @Override
    public int getDeckMinSize() {
        return 60;
    }

    @Override
    public int getSideboardMinSize() {
        return 0;
    }

    @Override
    public boolean validate(Deck deck) {
        boolean valid = true;
        this.errorsList.clear();
        if (deck.getMaindeckCards().size() < this.getDeckMinSize()) {
            this.addError(DeckValidatorErrorType.DECK_SIZE, "Deck", "Must contain at least " + this.getDeckMinSize() + " cards: has only " + deck.getMaindeckCards().size() + " cards");
            valid = false;
        }
        if (deck.getSideboard().size() > 15) {
            this.addError(DeckValidatorErrorType.DECK_SIZE, "Sideboard", "Must contain no more than 15 cards : has " + deck.getSideboard().size() + " cards");
            valid = false;
        }
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        this.countCards(counts, deck.getCards());
        this.countCards(counts, deck.getSideboard());
        valid = this.checkCounts(4, counts) && valid;
        for (String bannedCard : this.banned) {
            if (!counts.containsKey(bannedCard)) continue;
            this.addError(DeckValidatorErrorType.BANNED, bannedCard, "Banned", true);
            valid = false;
        }
        for (String restrictedCard : this.restricted) {
            int count;
            if (!counts.containsKey(restrictedCard) || (count = ((Integer)counts.get(restrictedCard)).intValue()) <= 1) continue;
            this.addError(DeckValidatorErrorType.OTHER, restrictedCard, "Restricted amount: " + count, true);
            valid = false;
        }
        if (!this.rarities.isEmpty()) {
            for (Card card : deck.getCards()) {
                if (this.rarities.contains((Object)card.getRarity()) || this.legalRarity(card)) continue;
                valid = false;
            }
            for (Card card : deck.getSideboard()) {
                if (this.rarities.contains((Object)card.getRarity()) || this.legalRarity(card)) continue;
                valid = false;
            }
        }
        for (Card card : deck.getCards()) {
            if (this.isSetAllowed(card.getExpansionSetCode()) || this.legalSets(card)) continue;
            valid = false;
        }
        for (Card card : deck.getSideboard()) {
            if (this.isSetAllowed(card.getExpansionSetCode()) || this.legalSets(card)) continue;
            valid = false;
        }
        return valid;
    }

    protected boolean legalRarity(Card card) {
        boolean legal = false;
        List<CardInfo> cardInfos = CardRepository.instance.findCards(card.getName());
        for (CardInfo cardInfo : cardInfos) {
            if (!this.rarities.contains((Object)cardInfo.getRarity())) continue;
            legal = true;
            break;
        }
        if (!legal && !this.errorsListContainsGroup(card.getName())) {
            this.addError(DeckValidatorErrorType.OTHER, card.getName(), "Invalid rarity: " + (Object)((Object)card.getRarity()), true);
        }
        return legal;
    }

    protected boolean isSetAllowed(String code) {
        return this.setCodes.isEmpty() || this.setCodes.contains(code);
    }

    protected boolean legalSets(Card card) {
        boolean legal = false;
        List<CardInfo> cardInfos = CardRepository.instance.findCards(card.getName());
        for (CardInfo cardInfo : cardInfos) {
            if (!this.isSetAllowed(cardInfo.getSetCode())) continue;
            legal = true;
            break;
        }
        if (this.singleCards.contains(card.getName())) {
            legal = true;
        }
        if (!legal && !this.errorsListContainsGroup(card.getName())) {
            this.addError(DeckValidatorErrorType.WRONG_SET, card.getName(), "Invalid set: " + card.getExpansionSetCode(), true);
        }
        return legal;
    }

    protected boolean checkCounts(int maxCopies, Map<String, Integer> counts) {
        boolean valid = true;
        for (Map.Entry<String, Integer> entry : counts.entrySet()) {
            if (entry.getValue() <= Constructed.getMaxCopies(entry.getKey(), maxCopies)) continue;
            this.addError(DeckValidatorErrorType.OTHER, entry.getKey(), "Too many: " + entry.getValue(), true);
            valid = false;
        }
        return valid;
    }
}

