/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.decks;

import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.cards.Card;
import mage.cards.decks.DeckCardInfo;
import mage.cards.decks.DeckCardLayout;
import mage.cards.decks.DeckCardLists;
import mage.cards.repository.CardInfo;
import mage.cards.repository.CardRepository;
import mage.game.GameException;
import mage.util.Copyable;
import mage.util.DeckUtil;

public class Deck
implements Serializable,
Copyable<Deck> {
    static final int MAX_CARDS_PER_DECK = 2000;
    private String name;
    private final Set<Card> cards = new LinkedHashSet<Card>();
    private final Set<Card> sideboard = new LinkedHashSet<Card>();
    private DeckCardLayout cardsLayout;
    private DeckCardLayout sideboardLayout;

    public Deck() {
    }

    protected Deck(Deck deck) {
        this.name = deck.name;
        this.cards.addAll(deck.cards.stream().map(Card::copy).collect(Collectors.toList()));
        this.sideboard.addAll(deck.sideboard.stream().map(Card::copy).collect(Collectors.toList()));
        this.cardsLayout = deck.cardsLayout == null ? null : deck.cardsLayout.copy();
        this.sideboardLayout = deck.sideboardLayout == null ? null : deck.sideboardLayout.copy();
    }

    public static Deck load(DeckCardLists deckCardLists) throws GameException {
        return Deck.load(deckCardLists, false);
    }

    public static Deck load(DeckCardLists deckCardLists, boolean ignoreErrors) throws GameException {
        return Deck.load(deckCardLists, ignoreErrors, true);
    }

    public static Deck append(Deck sourceDeck, Deck currentDeck) throws GameException {
        Deck newDeck = currentDeck.copy();
        sourceDeck.getCards().forEach(card -> newDeck.cards.add(card.copy()));
        sourceDeck.getSideboard().forEach(card -> newDeck.sideboard.add(card.copy()));
        return newDeck;
    }

    public static Deck load(DeckCardLists deckCardLists, boolean ignoreErrors, boolean mockCards) throws GameException {
        return Deck.load(deckCardLists, ignoreErrors, mockCards, null);
    }

    public static Deck load(DeckCardLists deckCardLists, boolean ignoreErrors, boolean mockCards, Map<String, CardInfo> cardInfoCache) throws GameException {
        Card card;
        int i;
        Deck deck = new Deck();
        deck.setName(deckCardLists.getName());
        deck.cardsLayout = deckCardLists.getCardLayout() == null ? null : deckCardLists.getCardLayout().copy();
        deck.sideboardLayout = deckCardLists.getSideboardLayout() == null ? null : deckCardLists.getSideboardLayout().copy();
        int totalCards = 0;
        block0: for (DeckCardInfo deckCardInfo : deckCardLists.getCards()) {
            for (i = 1; i <= deckCardInfo.getAmount(); ++i) {
                if (totalCards > 2000) break block0;
                card = Deck.createCard(deckCardInfo, mockCards, cardInfoCache);
                if (card != null) {
                    deck.cards.add(card);
                    ++totalCards;
                    continue;
                }
                if (ignoreErrors) continue;
                throw Deck.createCardNotFoundGameException(deckCardInfo, deckCardLists.getName());
            }
        }
        block2: for (DeckCardInfo deckCardInfo : deckCardLists.getSideboard()) {
            for (i = 1; i <= deckCardInfo.getAmount(); ++i) {
                if (totalCards > 2000) break block2;
                card = Deck.createCard(deckCardInfo, mockCards, cardInfoCache);
                if (card != null) {
                    deck.sideboard.add(card);
                    ++totalCards;
                    continue;
                }
                if (ignoreErrors) continue;
                throw Deck.createCardNotFoundGameException(deckCardInfo, deckCardLists.getName());
            }
        }
        return deck;
    }

    private static GameException createCardNotFoundGameException(DeckCardInfo deckCardInfo, String deckName) {
        if (CardRepository.checkDatabaseHealthAndFix()) {
            String cardError = String.format("Card not found - %s - %s - %s in deck %s.", deckCardInfo.getCardName(), deckCardInfo.getSetCode(), deckCardInfo.getCardNumber(), deckName);
            cardError = cardError + "\n\nPossible reasons:";
            cardError = cardError + "\n - deck problem: un-implemented card or outdated set (fix it by open in deck editor);";
            cardError = cardError + "\n - server problem: memory issue (load your deck again or wait a server's restart).";
            return new GameException(cardError);
        }
        return new GameException("Critical problems detected on the server side (memory issues), wait for a restart.");
    }

    private static Card createCard(DeckCardInfo deckCardInfo, boolean mockCards, Map<String, CardInfo> cardInfoCache) {
        CardInfo cardInfo;
        if (cardInfoCache != null) {
            String key = String.format("%s_%s", deckCardInfo.getSetCode(), deckCardInfo.getCardNumber());
            cardInfo = cardInfoCache.getOrDefault(key, null);
            if (cardInfo == null) {
                cardInfo = CardRepository.instance.findCard(deckCardInfo.getSetCode(), deckCardInfo.getCardNumber());
                cardInfoCache.put(key, cardInfo);
            }
        } else {
            cardInfo = CardRepository.instance.findCard(deckCardInfo.getSetCode(), deckCardInfo.getCardNumber());
        }
        if (cardInfo == null) {
            return null;
        }
        if (mockCards) {
            return cardInfo.createMockCard();
        }
        return cardInfo.createCard();
    }

    public DeckCardLists prepareCardsOnlyDeck() {
        DeckCardLists deckCardLists = new DeckCardLists();
        deckCardLists.setName(this.name);
        for (Card card : this.cards) {
            deckCardLists.getCards().add(new DeckCardInfo(card.getName(), card.getCardNumber(), card.getExpansionSetCode()));
        }
        for (Card card : this.sideboard) {
            deckCardLists.getSideboard().add(new DeckCardInfo(card.getName(), card.getCardNumber(), card.getExpansionSetCode()));
        }
        return deckCardLists;
    }

    public Set<String> getExpansionSetCodes() {
        LinkedHashSet<String> sets = new LinkedHashSet<String>();
        for (Card card : this.getCards()) {
            sets.add(card.getExpansionSetCode());
        }
        for (Card card : this.getSideboard()) {
            sets.add(card.getExpansionSetCode());
        }
        return sets;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<Card> getCards() {
        return this.cards;
    }

    public Set<Card> getMaindeckCards() {
        return this.cards.stream().filter(card -> !card.isExtraDeckCard()).collect(Collectors.toSet());
    }

    public Card findCard(UUID cardId) {
        return this.cards.stream().filter(card -> card.getId().equals(cardId)).findFirst().orElse(null);
    }

    public DeckCardLayout getCardsLayout() {
        return this.cardsLayout;
    }

    public Set<Card> getSideboard() {
        return this.sideboard;
    }

    public Card findSideboardCard(UUID cardId) {
        return this.sideboard.stream().filter(card -> card.getId().equals(cardId)).findFirst().orElse(null);
    }

    public DeckCardLayout getSideboardLayout() {
        return this.sideboardLayout;
    }

    public void clearLayouts() {
        this.cardsLayout = null;
        this.sideboardLayout = null;
    }

    @Override
    public Deck copy() {
        return new Deck(this);
    }

    public long getDeckHash(boolean ignoreMainBasicLands) {
        return DeckUtil.getDeckHash(this.cards.stream().map(MageObject::getName).collect(Collectors.toList()), this.sideboard.stream().map(MageObject::getName).collect(Collectors.toList()), ignoreMainBasicLands);
    }
}

