/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.decks.exporter;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import mage.cards.decks.DeckCardInfo;
import mage.cards.decks.DeckCardLayout;
import mage.cards.decks.DeckCardLists;
import mage.cards.decks.DeckFileFilter;
import mage.cards.decks.exporter.DeckExporter;

public class XmageDeckExporter
extends DeckExporter {
    private final String ext = "dck";
    private final String description = "XMage's deck format (*.dck)";
    private final FileFilter fileFilter = new DeckFileFilter("dck", "XMage's deck format (*.dck)");

    @Override
    public void writeDeck(PrintWriter out, DeckCardLists deck) {
        int curAmount;
        String code;
        ArrayList<DeckCardInfo> deckMain = new ArrayList<DeckCardInfo>();
        ArrayList<DeckCardInfo> deckSideboard = new ArrayList<DeckCardInfo>();
        HashMap<String, Integer> amount = new HashMap<String, Integer>();
        if (deck.getName() != null && !deck.getName().isEmpty()) {
            out.println("NAME:" + deck.getName());
        }
        if (deck.getAuthor() != null && !deck.getAuthor().isEmpty()) {
            out.println("AUTHOR:" + deck.getAuthor());
        }
        for (DeckCardInfo card : deck.getCards()) {
            code = "M@" + card.getCardKey();
            curAmount = amount.getOrDefault(code, 0);
            if (curAmount == 0) {
                deckMain.add(card);
            }
            amount.put(code, curAmount + card.getAmount());
        }
        for (DeckCardInfo card : deck.getSideboard()) {
            code = "S@" + card.getCardKey();
            curAmount = amount.getOrDefault(code, 0);
            if (curAmount == 0) {
                deckSideboard.add(card);
            }
            amount.put(code, curAmount + card.getAmount());
        }
        for (DeckCardInfo card : deckMain) {
            out.printf("%d [%s:%s] %s%n", amount.get("M@" + card.getCardKey()), card.getSetCode(), card.getCardNumber(), card.getCardName());
        }
        for (DeckCardInfo card : deckSideboard) {
            out.printf("SB: %d [%s:%s] %s%n", amount.get("S@" + card.getCardKey()), card.getSetCode(), card.getCardNumber(), card.getCardName());
        }
        if (deck.getCardLayout() != null) {
            out.print("LAYOUT MAIN:");
            XmageDeckExporter.writeCardLayout(out, deck.getCardLayout());
            out.println("");
            out.print("LAYOUT SIDEBOARD:");
            XmageDeckExporter.writeCardLayout(out, deck.getSideboardLayout());
            out.println("");
        }
    }

    private static void writeCardLayout(PrintWriter out, DeckCardLayout layout) {
        if (layout == null) {
            return;
        }
        List<List<List<DeckCardInfo>>> cardGrid = layout.getCards();
        int height = cardGrid.size();
        int width = height > 0 ? cardGrid.get(0).size() : 0;
        out.print("(" + height + ',' + width + ')');
        out.print(layout.getSettings());
        out.print("|");
        for (List<List<DeckCardInfo>> row : cardGrid) {
            for (List<DeckCardInfo> stack : row) {
                out.print("(");
                for (int i = 0; i < stack.size(); ++i) {
                    DeckCardInfo info = stack.get(i);
                    out.printf("[%s:%s]", info.getSetCode(), info.getCardNumber());
                    if (i == stack.size() - 1) continue;
                    out.print(",");
                }
                out.print(")");
            }
        }
    }

    @Override
    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    @Override
    public String getDescription() {
        return "XMage's deck format (*.dck)";
    }

    @Override
    public String getDefaultFileExt() {
        return "dck";
    }
}

