/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.decks.importer;

import java.io.File;
import java.util.Locale;
import java.util.Scanner;
import mage.cards.decks.DeckCardLists;
import mage.cards.decks.importer.CardLookup;
import mage.cards.decks.importer.CodDeckImporter;
import mage.cards.decks.importer.DckDeckImporter;
import mage.cards.decks.importer.DecDeckImporter;
import mage.cards.decks.importer.DekDeckImporter;
import mage.cards.decks.importer.DraftLogImporter;
import mage.cards.decks.importer.MWSDeckImporter;
import mage.cards.decks.importer.MtgaImporter;
import mage.cards.decks.importer.MtgjsonDeckImporter;
import mage.cards.decks.importer.O8dDeckImporter;
import mage.cards.decks.importer.TxtDeckImporter;
import org.apache.log4j.Logger;

public abstract class DeckImporter {
    protected static final Logger logger = Logger.getLogger(DeckImporter.class);
    private static final String[] SIDEBOARD_MARKS = new String[]{"//sideboard", "sb: "};

    public static DeckImporter getDeckImporter(String file) {
        if (file == null) {
            return null;
        }
        if (file.toLowerCase(Locale.ENGLISH).endsWith("dec")) {
            return new DecDeckImporter();
        }
        if (file.toLowerCase(Locale.ENGLISH).endsWith("mwdeck")) {
            return new MWSDeckImporter();
        }
        if (file.toLowerCase(Locale.ENGLISH).endsWith("txt")) {
            return new TxtDeckImporter(DeckImporter.haveSideboardSection(file));
        }
        if (file.toLowerCase(Locale.ENGLISH).endsWith("dck")) {
            return new DckDeckImporter();
        }
        if (file.toLowerCase(Locale.ENGLISH).endsWith("dek")) {
            return new DekDeckImporter();
        }
        if (file.toLowerCase(Locale.ENGLISH).endsWith("cod")) {
            return new CodDeckImporter();
        }
        if (file.toLowerCase(Locale.ENGLISH).endsWith("o8d")) {
            return new O8dDeckImporter();
        }
        if (file.toLowerCase(Locale.ENGLISH).endsWith("json")) {
            return new MtgjsonDeckImporter();
        }
        if (file.toLowerCase(Locale.ENGLISH).endsWith("draft")) {
            return new DraftLogImporter();
        }
        if (file.toLowerCase(Locale.ENGLISH).endsWith("mtga")) {
            return new MtgaImporter();
        }
        return null;
    }

    public static DeckCardLists importDeckFromFile(String file, boolean saveAutoFixedFile) {
        return DeckImporter.importDeckFromFile(file, new StringBuilder(), saveAutoFixedFile);
    }

    public static DeckCardLists importDeckFromFile(String file, StringBuilder errorMessages, boolean saveAutoFixedFile) {
        DeckImporter deckImporter = DeckImporter.getDeckImporter(file);
        if (deckImporter != null) {
            return deckImporter.importDeck(file, errorMessages, saveAutoFixedFile);
        }
        return new DeckCardLists();
    }

    public abstract DeckCardLists importDeck(String var1, StringBuilder var2, boolean var3);

    public DeckCardLists importDeck(String fileName, boolean saveAutoFixedFile) {
        return this.importDeck(fileName, new StringBuilder(), saveAutoFixedFile);
    }

    public CardLookup getCardLookup() {
        return CardLookup.instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean haveSideboardSection(String file) {
        File f = new File(file);
        try (Scanner scanner = new Scanner(f);){
            block14: while (true) {
                if (!scanner.hasNextLine()) return false;
                String line = scanner.nextLine().trim().toLowerCase(Locale.ENGLISH);
                String[] stringArray = SIDEBOARD_MARKS;
                int n = stringArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) continue block14;
                    String mark = stringArray[n2];
                    if (line.startsWith(mark)) {
                        boolean bl = true;
                        return bl;
                    }
                    ++n2;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static class FixedInfo {
        private final String originalLine;
        private String fixedLine;
        private Boolean canFix = true;

        FixedInfo(String originalLine) {
            this.originalLine = originalLine;
            this.fixedLine = originalLine;
        }

        public String getOriginalLine() {
            return this.originalLine;
        }

        public Boolean getCanFix() {
            return this.canFix;
        }

        public void setCanFix(Boolean canFix) {
            this.canFix = canFix;
        }

        public String getFixedLine() {
            return this.fixedLine;
        }

        public void setFixedLine(String fixedLine) {
            this.fixedLine = fixedLine;
        }
    }
}

